/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import logic.LogicComponent;
import logic.components.REG;
import main.Main;
import util.ComponentNameComparator;
import util.Messages;
import util.NameConnector;
import util.SimObserver;

public class RegisterDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    CPURegisterPanel panel;

    public RegisterDialog() {
        this.setTitle(Messages.getString("RegisterDialogConfigurable.Registers"));
        this.setIconImage(Main.getIcon());
        this.panel = new CPURegisterPanel(this, this.getRegs());
        this.add(this.panel);
        this.getRootPane().registerKeyboardAction(this.panel, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                RegisterDialog.this.setVisible(false);
                Main.centralPanel.update(false);
            }
        });
        this.setModal(false);
        this.setResizable(true);
        this.setLocation(50, Main.checkLocation(350));
        this.setVisible(false);
    }

    public void init() {
        this.panel.init();
    }

    private List<REG> getRegs() {
        HashSet<REG> resultSet = new HashSet<REG>();
        Map<String, LogicComponent> comps = NameConnector.listComponents();
        for (LogicComponent comp : comps.values()) {
            if (!(comp instanceof REG)) continue;
            resultSet.add((REG)comp);
        }
        LinkedList<REG> result = new LinkedList<REG>(resultSet);
        Collections.sort(result, new ComponentNameComparator());
        return result;
    }

    public SimObserver getObserver() {
        return this.panel;
    }

    class CPURegisterPanel
    extends JPanel
    implements ActionListener,
    SimObserver {
        private static final long serialVersionUID = 1L;
        private List<REG> regs;
        private Map<String, REG> regsNames;
        private List<JTextField> regsFields;
        private JButton izmeni;
        private JButton izadji;
        private JDialog greska;
        private JDialog potvrda;
        private JDialog sadrzalacRegistara;

        public JDialog getSadrzalacRegistara() {
            return this.sadrzalacRegistara;
        }

        public void setSadrzalacRegistara(JDialog sadrzalacRegistara) {
            this.sadrzalacRegistara = sadrzalacRegistara;
        }

        public CPURegisterPanel(RegisterDialog parent, List<REG> regs) {
            this.sadrzalacRegistara = parent;
            this.setLayout(new BorderLayout());
            this.setBackground(Color.white);
            this.regs = regs;
            this.regsNames = new HashMap<String, REG>();
            for (REG reg : regs) {
                this.regsNames.put(reg.getName(), reg);
            }
            this.regsFields = new LinkedList<JTextField>();
        }

        public void init() {
            int numV;
            Color bgcolor = Color.white;
            int numRegs = this.regs.size();
            int numC = Math.max((int)Math.sqrt(numRegs / 2), 1);
            if (numC * (numV = numRegs / numC) < numRegs) {
                ++numV;
            }
            GridLayout layout = new GridLayout(1, 2 * numC);
            layout.setHgap(10);
            JPanel registrisvi = new JPanel(layout);
            registrisvi.setBackground(bgcolor);
            int index = 0;
            int i = 0;
            while (i < numC) {
                GridLayout valuesLayout = new GridLayout(numV, 1);
                valuesLayout.setVgap(10);
                JPanel values = new JPanel(valuesLayout);
                values.setBackground(bgcolor);
                GridLayout labledLayout = new GridLayout(numV, 1);
                labledLayout.setVgap(10);
                JPanel lables = new JPanel(labledLayout);
                lables.setBackground(bgcolor);
                int j = 0;
                while (j < numV && index < numRegs) {
                    REG reg = this.regs.get(index);
                    JLabel ime = new JLabel(reg.getName());
                    ime.setVerticalAlignment(0);
                    ime.setHorizontalAlignment(4);
                    lables.add(ime);
                    JTextField regPolje = new JTextField(5);
                    regPolje.setColumns(3);
                    regPolje.setText(Integer.toHexString(reg.getVal()));
                    regPolje.setName(reg.getName());
                    this.regsFields.add(regPolje);
                    values.add(regPolje);
                    ++j;
                    ++index;
                }
                registrisvi.add(lables);
                registrisvi.add(values);
                ++i;
            }
            this.add((Component)registrisvi, "Center");
            JPanel komande = new JPanel();
            komande.setBackground(bgcolor);
            this.izmeni = new JButton(Messages.getString("RegisterDialogConfigurable.Change"));
            this.izmeni.addActionListener(this);
            this.izadji = new JButton(Messages.getString("RegisterDialogConfigurable.Cancel"));
            this.izadji.addActionListener(this);
            komande.add(this.izmeni);
            komande.add(this.izadji);
            this.add((Component)komande, "South");
        }

        @Override
        public void actionPerformed(ActionEvent arg) {
            if (arg.getActionCommand() != null && arg.getActionCommand().equals(Messages.getString("RegisterDialogConfigurable.Change"))) {
                boolean error = false;
                int cnt = this.regs.size();
                boolean[] nizvrednosti = new boolean[cnt];
                int i = 0;
                while (i < cnt) {
                    nizvrednosti[i] = this.proveri(this.regsFields.get(i));
                    error = error || nizvrednosti[i];
                    ++i;
                }
                if (!error) {
                    i = 0;
                    while (i < cnt) {
                        JTextField regsField = this.regsFields.get(i);
                        REG reg = this.regsNames.get(regsField.getName());
                        reg.setVal(this.dohvatiVrednost(this.regsFields.get(i)));
                        ++i;
                    }
                    Main.centralPanel.update(true);
                } else {
                    error = false;
                    this.showWtiteError();
                }
            } else {
                this.sadrzalacRegistara.setVisible(false);
            }
            this.repaint();
        }

        public void showWtiteError() {
            this.greska = new JDialog();
            this.greska.setIconImage(Main.getIcon());
            this.greska.setSize(550, 150);
            this.greska.setLocation(200, 200);
            this.greska.setModal(true);
            this.greska.setTitle(Messages.getString("RegisterDialogConfigurable.Greska"));
            JPanel osnovni = new JPanel(new GridLayout(3, 1));
            JLabel lab = new JLabel(Messages.getString("RegisterDialogConfigurable.Poruka_neuspesna_promena"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JLabel lab1 = new JLabel(Messages.getString("RegisterDialogConfigurable.Poruka_akcija_neuspesne_promene"));
            lab1.setHorizontalAlignment(0);
            osnovni.add(lab1);
            JButton ok = new JButton(Messages.getString("RegisterDialogConfigurable.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CPURegisterPanel.this.greska.setVisible(false);
                    CPURegisterPanel.this.sadrzalacRegistara.setVisible(true);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.greska.add(osnovni);
            this.greska.setVisible(true);
        }

        public void showWriteOK() {
            this.potvrda = new JDialog();
            this.potvrda.setIconImage(Main.getIcon());
            this.potvrda.setSize(350, 100);
            this.potvrda.setLocation(200, 200);
            this.potvrda.setModal(true);
            this.potvrda.setTitle(Messages.getString("RegisterDialogConfigurable.Potvrda"));
            JPanel osnovni = new JPanel(new GridLayout(2, 1));
            JLabel lab = new JLabel(Messages.getString("RegisterDialogConfigurable.Poruka_uspesna_promena"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JButton ok = new JButton(Messages.getString("RegisterDialogConfigurable.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CPURegisterPanel.this.potvrda.setVisible(false);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.potvrda.add(osnovni);
            this.potvrda.setVisible(true);
        }

        private boolean proveri(JTextField field) {
            int val;
            boolean error = false;
            REG reg = this.regsNames.get(field.getName());
            String text = field.getText();
            try {
                val = Integer.parseInt(text, 16);
            }
            catch (Exception e) {
                error = true;
                return error;
            }
            int validBits = reg.getOutPin(0).isBool() ? reg.getOutPins().length : reg.getOutPin(0).getNumOfLines();
            if ((int)Math.pow(2.0, validBits) <= val) {
                error = true;
            }
            return error;
        }

        private int dohvatiVrednost(JTextField field) {
            int val;
            String text = field.getText();
            try {
                val = Integer.parseInt(text, 16);
            }
            catch (Exception e) {
                return 0;
            }
            return val;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            for (JTextField field : this.regsFields) {
                field.setText(RegFormater.format(this.regsNames.get(field.getName())));
            }
        }

        @Override
        public void update() {
            if (this.isVisible() && this.isChanged()) {
                this.repaint();
            }
        }

        public boolean isChanged() {
            boolean result = false;
            for (JTextField field : this.regsFields) {
                String s = RegFormater.format(this.regsNames.get(field.getName()));
                if (field.getText().equals(s)) continue;
                result = true;
                break;
            }
            return result;
        }
    }

    public static class RegFormater {
        public static int getSize(REG reg) {
            int validBits = reg.getOutPin(0).isBool() ? reg.getOutPins().length : reg.getOutPin(0).getNumOfLines();
            return 1 + (validBits + 3) / 4;
        }

        public static String format(REG reg) {
            int validBits = reg.getOutPin(0).isBool() ? reg.getOutPins().length : reg.getOutPin(0).getNumOfLines();
            if ((validBits = (validBits + 3) / 4) == 0) {
                validBits = 1;
            }
            String result = String.format("%0" + validBits + "x", reg.getVal());
            return result;
        }

        public static int reformat(String val, REG reg) {
            int result = 0;
            try {
                result = Integer.parseInt(val, 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
    }
}

