/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import main.EditorHighlight;
import main.SimulatorActions;
import main.UndoRedo;
import shemes.Schema;
import util.Parameters;

public class ParameterEditorPanel
extends JPanel {
    public static final String NAME = "ParameterEditor";
    private static final long serialVersionUID = 1L;
    boolean changed;
    boolean setting;
    private Map<Schema, String> configuration;
    Map<Schema, String> comments;
    Schema schema;
    JTextArea comment;
    JTextArea parameters;
    UndoRedo undoRedo;
    EditorHighlight editorHighlight;

    public ParameterEditorPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.changed = false;
        this.setting = false;
        this.configuration = new HashMap<Schema, String>();
        this.comments = new HashMap<Schema, String>();
        this.schema = null;
        this.comment = new JTextArea("//No configuration required");
        this.comment.setEditable(false);
        this.comment.setFont(new Font("Consolas", 0, 14));
        this.comment.setForeground(new Color(63, 127, 95));
        this.add("North", this.comment);
        this.parameters = new JTextArea("");
        this.parameters.setFont(new Font("Consolas", 0, 14));
        this.parameters.setForeground(Color.BLACK);
        this.parameters.getDocument().addDocumentListener(new MyDocumentListener());
        this.add("South", this.parameters);
        this.undoRedo = new UndoRedo(NAME);
        this.undoRedo.undoredo(this.parameters);
        this.editorHighlight = new EditorHighlight(this.parameters, Color.YELLOW);
        this.parameters.addCaretListener(this.editorHighlight);
    }

    public void update() {
        String data = this.parameters.getText();
        if (this.schema != null) {
            this.configuration.put(this.schema, data);
        }
    }

    public void changeSchema(Schema newSchema) {
        if (this.schema == newSchema) {
            return;
        }
        String data = this.parameters.getText();
        if (this.schema != null) {
            this.configuration.put(this.schema, data);
        }
        this.schema = newSchema;
        data = this.configuration.get(this.schema);
        if (data == null) {
            data = Parameters.configuration.get(this.schema.getClass());
        }
        if (data == null) {
            data = "";
        }
        this.configuration.put(this.schema, data);
        this.setting = true;
        this.parameters.setText(data);
        this.undoRedo.reset();
        this.setting = false;
        this.parameters.validate();
        data = this.comments.get(this.schema);
        if (data == null) {
            data = Parameters.comments.get(this.schema.getClass());
        }
        if (data == null) {
            data = "//No configuration required";
        }
        this.comment.setText(data);
        this.comment.validate();
    }

    public Map<Schema, String> getConfiguration() {
        this.update();
        return this.configuration;
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String oldData = (String)ParameterEditorPanel.this.configuration.get(ParameterEditorPanel.this.schema);
            String data = ParameterEditorPanel.this.parameters.getText();
            if (!ParameterEditorPanel.this.setting && oldData != null && data != null && !oldData.equals(data)) {
                ParameterEditorPanel.this.changed = true;
                ParameterEditorPanel.this.configuration.put(ParameterEditorPanel.this.schema, data);
                SimulatorActions.configurationChanged();
            }
        }
    }
}

