/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import logic.LogicComponent;
import logic.components.FF;
import main.Main;
import util.ComponentNameComparator;
import util.Messages;
import util.NameConnector;
import util.SimObserver;

public class FlipflopDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    CPUFlipflopPanel panel;

    public FlipflopDialog() {
        this.setTitle(Messages.getString("FlipflopDialogConfigurable.Flip_flops"));
        this.setIconImage(Main.getIcon());
        this.panel = new CPUFlipflopPanel(this, this.getFFs());
        this.add(this.panel);
        this.getRootPane().registerKeyboardAction(this.panel, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FlipflopDialog.this.setVisible(false);
                Main.centralPanel.update(false);
            }
        });
        this.setModal(false);
        this.setResizable(false);
        this.setLocation(50, Main.checkLocation(750));
        this.setVisible(false);
    }

    public void init() {
        this.panel.init();
    }

    private List<FF> getFFs() {
        HashSet<FF> resultSet = new HashSet<FF>();
        Map<String, LogicComponent> comps = NameConnector.listComponents();
        for (LogicComponent comp : comps.values()) {
            if (!(comp instanceof FF)) continue;
            resultSet.add((FF)comp);
        }
        LinkedList<FF> result = new LinkedList<FF>(resultSet);
        Collections.sort(result, new ComponentNameComparator());
        return result;
    }

    public SimObserver getObserver() {
        return this.panel;
    }

    class CPUFlipflopPanel
    extends JPanel
    implements ActionListener,
    SimObserver {
        private static final long serialVersionUID = 1L;
        private List<FF> ffs;
        private Map<String, FF> ffsNames;
        private List<JTextField> ffsFields;
        private JButton izmeni;
        private JButton izadji;
        private JDialog greska;
        private JDialog potvrda;
        private JDialog sadrzalacFFs;

        public JDialog getSadrzalacFFs() {
            return this.sadrzalacFFs;
        }

        public void setSadrzalacFFs(JDialog sadrzalacFFs) {
            this.sadrzalacFFs = sadrzalacFFs;
        }

        public CPUFlipflopPanel(FlipflopDialog parent, List<FF> ffs) {
            this.sadrzalacFFs = parent;
            this.setLayout(new BorderLayout());
            this.setBackground(Color.white);
            this.ffs = ffs;
            this.ffsNames = new HashMap<String, FF>();
            for (FF ff : ffs) {
                this.ffsNames.put(ff.getName(), ff);
            }
            this.ffsFields = new LinkedList<JTextField>();
        }

        public void init() {
            int numV;
            Color bgcolor = Color.white;
            int numFFs = this.ffs.size();
            int numC = Math.max((int)Math.sqrt(numFFs / 2), 1);
            if (numC * (numV = numFFs / numC) < numFFs) {
                ++numV;
            }
            GridLayout layout = new GridLayout(1, 2 * numC);
            layout.setHgap(10);
            JPanel ffAll = new JPanel(layout);
            ffAll.setBackground(bgcolor);
            int index = 0;
            int i = 0;
            while (i < numC) {
                GridLayout valuesLayout = new GridLayout(numV, 1);
                valuesLayout.setVgap(10);
                JPanel values = new JPanel(valuesLayout);
                values.setBackground(bgcolor);
                GridLayout labledLayout = new GridLayout(numV, 1);
                labledLayout.setVgap(10);
                JPanel lables = new JPanel(labledLayout);
                lables.setBackground(bgcolor);
                int j = 0;
                while (j < numV && index < numFFs) {
                    FF ff = this.ffs.get(index);
                    JLabel ime = new JLabel(ff.getName());
                    ime.setVerticalAlignment(0);
                    ime.setHorizontalAlignment(4);
                    lables.add(ime);
                    JTextField ffPolje = new JTextField(5);
                    ffPolje.setColumns(3);
                    ffPolje.setText(Integer.toHexString(ff.getState()));
                    ffPolje.setName(ff.getName());
                    this.ffsFields.add(ffPolje);
                    values.add(ffPolje);
                    ++j;
                    ++index;
                }
                ffAll.add(lables);
                ffAll.add(values);
                ++i;
            }
            this.add((Component)ffAll, "Center");
            JPanel komande = new JPanel();
            komande.setBackground(bgcolor);
            this.izmeni = new JButton(Messages.getString("FlipflopDialogConfigurable.Change"));
            this.izmeni.addActionListener(this);
            this.izadji = new JButton(Messages.getString("FlipflopDialogConfigurable.Cancel"));
            this.izadji.addActionListener(this);
            komande.add(this.izmeni);
            komande.add(this.izadji);
            this.add((Component)komande, "South");
        }

        @Override
        public void actionPerformed(ActionEvent arg) {
            if (arg.getActionCommand() != null && arg.getActionCommand().equals(Messages.getString("FlipflopDialogConfigurable.Change"))) {
                boolean error = false;
                int cnt = this.ffs.size();
                boolean[] nizvrednosti = new boolean[cnt];
                int i = 0;
                while (i < cnt) {
                    nizvrednosti[i] = this.proveri(this.ffsFields.get(i));
                    error = error || nizvrednosti[i];
                    ++i;
                }
                if (!error) {
                    i = 0;
                    while (i < cnt) {
                        JTextField ffField = this.ffsFields.get(i);
                        FF ff = this.ffsNames.get(ffField.getName());
                        ff.setState(this.dohvatiVrednost(this.ffsFields.get(i)));
                        ++i;
                    }
                    Main.centralPanel.update(true);
                } else {
                    error = false;
                    this.showWriteError();
                }
            } else {
                this.sadrzalacFFs.setVisible(false);
            }
            this.repaint();
        }

        public void showWriteError() {
            this.greska = new JDialog();
            this.greska.setIconImage(Main.getIcon());
            this.greska.setSize(550, 150);
            this.greska.setLocation(200, 200);
            this.greska.setModal(true);
            this.greska.setTitle(Messages.getString("FlipflopDialogConfigurable.Greska"));
            JPanel osnovni = new JPanel(new GridLayout(3, 1));
            JLabel lab = new JLabel(Messages.getString("FlipflopDialogConfigurable.Poruka_neuspesna_promena"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JLabel lab1 = new JLabel(Messages.getString("FlipflopDialogConfigurable.Poruka_akcija_neuspesne_promene"));
            lab1.setHorizontalAlignment(0);
            osnovni.add(lab1);
            JButton ok = new JButton(Messages.getString("FlipflopDialogConfigurable.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CPUFlipflopPanel.this.greska.setVisible(false);
                    CPUFlipflopPanel.this.sadrzalacFFs.setVisible(true);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.greska.add(osnovni);
            this.greska.setVisible(true);
        }

        public void showWriteOK() {
            this.potvrda = new JDialog();
            this.potvrda.setIconImage(Main.getIcon());
            this.potvrda.setSize(350, 100);
            this.potvrda.setLocation(200, 200);
            this.potvrda.setModal(true);
            this.potvrda.setTitle(Messages.getString("FlipflopDialogConfigurable.Potvrda"));
            JPanel osnovni = new JPanel(new GridLayout(2, 1));
            JLabel lab = new JLabel(Messages.getString("FlipflopDialogConfigurable.Poruka_uspesna_promena"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JButton ok = new JButton(Messages.getString("FlipflopDialogConfigurable.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CPUFlipflopPanel.this.potvrda.setVisible(false);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.potvrda.add(osnovni);
            this.potvrda.setVisible(true);
        }

        private boolean proveri(JTextField field) {
            int val;
            boolean error = false;
            String text = field.getText();
            try {
                val = Integer.parseInt(text, 16);
            }
            catch (Exception e) {
                error = true;
                return error;
            }
            if (val != 0 && val != 1) {
                error = true;
            }
            return error;
        }

        private int dohvatiVrednost(JTextField field) {
            int val;
            String text = field.getText();
            try {
                val = Integer.parseInt(text, 16);
            }
            catch (Exception e) {
                return 0;
            }
            return val;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            for (JTextField field : this.ffsFields) {
                field.setText(FFFormater.format(this.ffsNames.get(field.getName())));
            }
        }

        @Override
        public void update() {
            if (this.isVisible() && this.isChanged()) {
                this.repaint();
            }
        }

        public boolean isChanged() {
            boolean result = false;
            for (JTextField field : this.ffsFields) {
                String s = FFFormater.format(this.ffsNames.get(field.getName()));
                if (field.getText().equals(s)) continue;
                result = true;
                break;
            }
            return result;
        }
    }

    public static class FFFormater {
        public static int getSize(FF ff) {
            return 1;
        }

        public static String format(FF ff) {
            int validBits = 1;
            String result = String.format("%0" + validBits + "x", ff.getState());
            return result;
        }

        public static int reformat(String val, FF ff) {
            int result = 0;
            try {
                result = Integer.parseInt(val, 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
    }
}

