/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class EditorHighlight
extends DefaultHighlighter.DefaultHighlightPainter
implements CaretListener {
    JTextComponent editor;
    int hiliteCnt;

    public EditorHighlight(JTextComponent editor, Color color) {
        super(color);
        this.editor = editor;
        this.hiliteCnt = 0;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.displaySelectionInfo(e.getDot(), e.getMark());
    }

    protected void displaySelectionInfo(final int dot, final int mark) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (dot != mark) {
                    EditorHighlight.this.highlight();
                } else {
                    EditorHighlight.this.removeHighlights();
                }
            }
        });
    }

    protected void highlight() {
        String pattern = this.editor.getSelectedText();
        this.highlight(pattern);
    }

    protected void highlight(String pattern) {
        try {
            this.removeHighlights();
            pattern = pattern.toLowerCase();
            Highlighter hilite = this.editor.getHighlighter();
            Document doc = this.editor.getDocument();
            String text = null;
            try {
                text = doc.getText(0, doc.getLength());
                text = text.toLowerCase();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int pos = 0;
            while ((pos = text.indexOf(pattern, pos)) >= 0) {
                try {
                    hilite.addHighlight(pos, pos + pattern.length(), this);
                    ++this.hiliteCnt;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                pos += pattern.length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeHighlights() {
        if (this.hiliteCnt > 0) {
            Highlighter hilite = this.editor.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            int i = 0;
            while (i < hilites.length) {
                if (hilites[i].getPainter() instanceof EditorHighlight) {
                    hilite.removeHighlight(hilites[i]);
                    --this.hiliteCnt;
                }
                ++i;
            }
        }
    }
}

