/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.Pin;
import logic.components.FF;
import util.Log;

public class RSFF
extends FF {
    protected boolean err = false;

    public RSFF(String name) {
        super(2, name);
    }

    @Override
    public void func() {
        if (this.clk == null) {
            Log.errorDialog(":Error!!! Register " + this.name + " is not connected to clock.");
            return;
        }
        if (this.clk != null && !this.clk.getBoolVal()) {
            return;
        }
        if (this.reset != null && this.reset.getBoolVal()) {
            this.state = false;
            return;
        }
        if (this.in[0].getBoolVal() && this.in[1].getBoolVal()) {
            Log.errorDialog(":Error!!! Unexpected RSFF state..." + this.name);
            this.err = true;
            return;
        }
        this.err = false;
        this.state = this.in[0].getBoolVal() || !this.in[1].getBoolVal() && this.out[0].getBoolVal();
    }

    public void setPinR(Pin r) {
        this.setInPin(1, r);
    }

    public void setPinS(Pin s) {
        this.setInPin(0, s);
    }

    @Override
    public void setOutput() {
        this.out[0].setHighZ(this.err);
        this.out[1].setHighZ(this.err);
        this.out[0].setBoolVal(this.state);
        this.out[1].setBoolVal(!this.state);
    }
}

