/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.Execution;
import logic.Pin;
import logic.components.CLK;
import util.Log;
import util.Mask;

public class REG_Temp
extends AbstractLogicComponent {
    private static final int LD = 0;
    private static final int CL = 1;
    private static final int INC = 2;
    private static final int DEC = 3;
    private static final int SHR = 4;
    private static final int SHL = 5;
    private static final int IR = 6;
    private static final int IL = 7;
    private static final int CARRY = 8;
    private Pin clk;
    private int value;
    private boolean c;
    private int init;
    private Pin[] controlPins;

    public REG_Temp(int in, String name) {
        super(in, in, name, 1);
        this.value = 0;
        this.c = false;
        if (in > 0) {
            Execution.addSequentialComponent(this);
        }
        this.controlPins = new Pin[9];
        this.controlPins[8] = new Pin("");
        this.allPins.add(this.controlPins[8]);
    }

    public REG_Temp(int in, int width, String name) {
        super(in, in, name, 1);
        int i = 0;
        while (i < in) {
            this.allPins.remove(this.out[i]);
            ++i;
        }
        i = 0;
        while (i < in) {
            this.out[i] = new Pin(0, width, "");
            this.allPins.add(this.out[i]);
            ++i;
        }
        this.value = 0;
        this.c = false;
        if (in > 0) {
            Execution.addSequentialComponent(this);
        }
        this.controlPins = new Pin[9];
    }

    @Override
    public void func() {
        if (this.clk == null) {
            Log.errorDialog(":Error!!! Register " + this.name + " is not connected to clock.");
            return;
        }
        if (this.clk != null && !this.clk.getBoolVal()) {
            return;
        }
        int val = 0;
        if (this.controlPins[1] != null && this.controlPins[1].getBoolVal()) {
            ++val;
        }
        if (this.controlPins[0] != null && this.controlPins[0].getBoolVal()) {
            ++val;
        }
        if (this.controlPins[2] != null && this.controlPins[2].getBoolVal()) {
            ++val;
        }
        if (this.controlPins[3] != null && this.controlPins[3].getBoolVal()) {
            ++val;
        }
        if (this.controlPins[4] != null && this.controlPins[4].getBoolVal()) {
            ++val;
        }
        if (this.controlPins[5] != null && this.controlPins[5].getBoolVal()) {
            ++val;
        }
        if (val > 1) {
            Log.errorDialog(":Error!!! Multiple register action...");
            return;
        }
        if (this.controlPins[1] != null && this.controlPins[1].getBoolVal()) {
            this.value = 0;
            this.c = false;
            return;
        }
        if (this.controlPins[0] != null && this.controlPins[0].getBoolVal()) {
            this.value = this.getInput() & this.createMask();
            this.c = false;
            return;
        }
        if (this.controlPins[5] != null && this.controlPins[5].getBoolVal()) {
            this.c = (this.value & 1 << this.in[0].getNumOfLines() - 1) == 1;
            this.value <<= 1;
            if (this.controlPins[7] != null && this.controlPins[7].getBoolVal()) {
                this.value |= 1;
            }
            this.value &= this.createMask();
            return;
        }
        if (this.controlPins[4] != null && this.controlPins[4].getBoolVal()) {
            this.c = (this.value & 1) == 1;
            this.value >>= 1;
            if (this.controlPins[6] != null && this.controlPins[6].getBoolVal()) {
                this.value |= 1 << this.in[0].getNumOfLines() - 1;
            }
            this.value &= this.createMask();
            return;
        }
        if (this.controlPins[2] != null && this.controlPins[2].getBoolVal()) {
            ++this.value;
            this.value &= this.createMask();
            this.c = this.value == 0;
            return;
        }
        if (this.controlPins[3] != null && this.controlPins[3].getBoolVal()) {
            int mask = this.createMask();
            --this.value;
            this.value &= mask;
            this.c = this.value == mask;
            return;
        }
    }

    @Override
    public void propagate() {
        if (this.out[0].isBool()) {
            int priv = this.value;
            int j = 0;
            while (j < this.out.length) {
                boolean mod = (priv & 1) == 1;
                priv >>= 1;
                this.out[j].setBoolVal(mod);
                ++j;
            }
        } else {
            this.out[0].setIntVal(this.value);
        }
        if (this.controlPins[8] != null) {
            this.controlPins[8].setBoolVal(this.c);
        }
    }

    private int getInput() {
        if (this.in[0].isBool()) {
            int suma = 0;
            int j = 0;
            while (j < this.in.length) {
                if (this.in[j].getBoolVal()) {
                    suma += 1 << j;
                }
                ++j;
            }
            return suma;
        }
        return this.in[0].getIntVal();
    }

    public void setPinInc(Pin inc) {
        this.controlPins[2] = inc;
        inc.addChild(this);
    }

    public void setPinDec(Pin dec) {
        this.controlPins[3] = dec;
        dec.addChild(this);
    }

    public void setPinCL(Pin cl) {
        this.controlPins[1] = cl;
        cl.addChild(this);
    }

    public void setPinLd(Pin ld) {
        this.controlPins[0] = ld;
        ld.addChild(this);
    }

    public int getVal() {
        return this.value;
    }

    public void initVal(int value) {
        this.value = value;
        this.init = value;
    }

    public void setVal(int val) {
        this.value = val & this.createMask();
        this.propagate();
    }

    public void setShr(Pin shr) {
        this.controlPins[4] = shr;
        shr.addChild(this);
    }

    public void setShl(Pin shl) {
        this.controlPins[5] = shl;
        shl.addChild(this);
    }

    public Pin getC() {
        return this.controlPins[8];
    }

    public void setIR(Pin ir) {
        this.controlPins[6] = ir;
        ir.addChild(this);
    }

    public void setIL(Pin il) {
        this.controlPins[7] = il;
        il.addChild(this);
    }

    @Override
    public void init(boolean fullInit) {
        this.value = this.init;
        this.propagate();
    }

    public int createMask() {
        int size = this.getOutPin(0).isBool() ? this.out.length : this.getOutPin(0).getNumOfLines();
        try {
            return Mask.createMask(size);
        }
        catch (Exception e) {
            throw new RuntimeException("Maxima REG size 32: " + this.name + ": " + size);
        }
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
        int i = 0;
        while (i < this.out.length) {
            this.out[i].setName(args[12 + this.in.length + i]);
            ++i;
        }
        if (!args[11].isEmpty()) {
            if (this.controlPins[8] == null) {
                this.controlPins[8] = new Pin("");
                this.allPins.add(this.controlPins[8]);
            }
            this.controlPins[8].setName(args[11]);
        }
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.name) + "=" + this.value;
        return result;
    }

    public void setClk(CLK clk) {
        this.clk = clk.getClk();
        this.period = clk.getPeriod();
    }

    public String getControlPinName(int index) {
        return this.controlPins[index] == null ? "" : this.controlPins[index].getName();
    }

    public Pin getControlPin(int index) {
        return this.controlPins[index];
    }

    public void setControlPin(int index, Pin pin) {
        switch (index) {
            case 0: {
                this.setPinLd(pin);
                break;
            }
            case 1: {
                this.setPinCL(pin);
                break;
            }
            case 2: {
                this.setPinInc(pin);
                break;
            }
            case 3: {
                this.setPinDec(pin);
                break;
            }
            case 4: {
                this.setShr(pin);
                break;
            }
            case 5: {
                this.setShl(pin);
                break;
            }
            case 6: {
                this.setIR(pin);
                break;
            }
            case 7: {
                this.setIL(pin);
            }
        }
    }

    public String getType() {
        return this.args[0];
    }
}

