/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import java.util.List;
import logic.AbstractLogicComponent;
import util.Log;
import util.MicrocodeConverter;
import util.Parameters;

public class MicroMEM
extends AbstractLogicComponent {
    private String[] memory;

    public MicroMEM(int numLines, int numRows, List<String> microcode) {
        super(1, numLines);
        int i = 0;
        while (i < numLines) {
            this.out[i].setIsBool();
            this.out[i].setNumOfLines(1);
            ++i;
        }
        this.memory = new String[numRows];
        this.init(microcode);
    }

    protected void init(List<String> microcode) {
        int counter = 0;
        try {
            MicrocodeConverter.init(Parameters.controlUnitDecoder);
            MicrocodeConverter c = new MicrocodeConverter();
            List<String> lines = c.parse(microcode);
            for (String line : lines) {
                if (line == null) {
                    line = "";
                }
                this.memory[counter++] = line;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void func() {
        Log.log(this.memory[this.in[0].getIntVal()]);
        try {
            int i = 0;
            while (i < this.out.length) {
                this.out[i].setBoolVal(false);
                ++i;
            }
            String line = this.memory[this.in[0].getIntVal()];
            int i2 = 0;
            while (i2 < this.out.length) {
                int currentChar = Integer.parseInt(line.substring(i2 / 4, i2 / 4 + 1), 16);
                int j = 3;
                while (j >= 0) {
                    this.out[i2 + j].setBoolVal((currentChar & 1) == 1);
                    currentChar >>= 1;
                    --j;
                }
                i2 += 4;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.errorLog(e, "MicroMem Error " + this.in[0].getIntVal());
        }
    }

    public String getAllOut() {
        return this.memory[this.in[0].getIntVal()];
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }
}

