/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import logic.AbstractLogicComponent;
import logic.Execution;
import logic.Pin;
import util.Loader;
import util.Log;
import util.Mask;

public class MEM
extends AbstractLogicComponent {
    private Map<Integer, String> memory;
    private Pin read;
    private Pin write;
    private int adressSize;
    private int dataSize;

    public MEM(int adressSize, int dataSize, String name) {
        super(2, 1, name, 1);
        this.out[0].setIsInt();
        this.adressSize = adressSize;
        this.dataSize = dataSize;
        this.memory = new HashMap<Integer, String>();
        Execution.addSequentialComponent(this);
    }

    @Override
    public void func() {
        String data;
        int adress;
        if (this.write.getBoolVal()) {
            adress = this.in[0].getIntVal();
            data = Integer.toString(this.in[1].getIntVal(), 16);
            this.memory.put(adress, data);
        }
        if (this.read.getBoolVal()) {
            adress = this.in[0].getIntVal();
            data = this.memory.get(adress);
            if (data == null) {
                data = "0";
            }
            this.out[0].setIntVal(Integer.parseInt(data, 16));
        }
        if (!this.read.getBoolVal() && !this.write.getBoolVal()) {
            this.out[0].setIntVal(0);
        }
    }

    public void setRead(Pin read) {
        this.read = read;
        read.addChild(this);
    }

    public void setWrite(Pin write) {
        this.write = write;
        write.addChild(this);
    }

    public void write(int adress, int data) {
        this.memory.put(adress, Integer.toString(data, 16));
    }

    public int read(int adress) {
        String data = this.memory.get(adress);
        if (data == null) {
            data = "0";
        }
        return Integer.parseInt(data, 16);
    }

    public void initFromFile(String fileName) {
        BufferedReader reader = null;
        try {
            try {
                String line;
                int addressMask = Mask.createMask(this.adressSize);
                int dataMask = Mask.createMask(this.dataSize);
                reader = new BufferedReader(new FileReader(fileName));
                while ((line = reader.readLine()) != null) {
                    this.loadLine(addressMask, dataMask, line);
                }
            }
            catch (Exception e) {
                Log.errorLog(e, "Init from file " + fileName);
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    Log.errorLog(e2, "Closing file " + fileName);
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                Log.errorLog(e, "Closing file " + fileName);
            }
        }
    }

    protected void loadLine(int addressMask, int dataMask, String line) {
        try {
            line = Loader.removeComments(line);
            String[] linData = line.split(",");
            if (linData.length == 2) {
                String adr = linData[0].trim();
                int intAdr = Integer.parseInt(adr, 16);
                String data = linData[1].trim();
                int intData = Integer.parseInt(data, 16);
                this.memory.put(intAdr &= addressMask, Integer.toString(intData &= dataMask, 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLine(String line) {
        try {
            int addressMask = Mask.createMask(this.adressSize);
            int dataMask = Mask.createMask(this.dataSize);
            line = Loader.removeComments(line);
            String[] linData = line.split(",");
            if (linData.length == 2) {
                String adr = linData[0].trim();
                int intAdr = Integer.parseInt(adr, 16);
                String data = linData[1].trim();
                int intData = Integer.parseInt(data, 16);
                this.memory.put(intAdr &= addressMask, Integer.toString(intData &= dataMask, 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init(boolean fullInit) {
        if (fullInit) {
            this.memory.clear();
        }
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }

    public Map<Integer, String> getMemory() {
        return this.memory;
    }
}

