/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.Pin;
import util.Log;

public class IntToInt
extends AbstractLogicComponent {
    private int numInputLines;
    private int numOutputLines;
    private boolean withSign;
    private boolean seeHighBits;
    private int startPosition;

    public IntToInt(int nil, int nol) {
        this(nil, nol, false, false, 0);
    }

    public IntToInt(int nil, int nol, boolean shb, boolean withS) {
        this(nil, nol, shb, withS, 0);
    }

    public IntToInt(int nil, int nol, boolean shb, boolean withS, int startPosition) {
        super(1, 1);
        this.numInputLines = nil;
        this.numOutputLines = nol;
        this.seeHighBits = shb;
        this.withSign = withS;
        this.startPosition = startPosition;
        this.out[0].setIsInt();
        this.out[0].setNumOfLines(nol);
    }

    @Override
    public void func() {
        if (this.in[0].isHighZ()) {
            this.out[0].setHighZ(true);
            return;
        }
        this.out[0].setHighZ(false);
        int inData = this.in[0].getIntVal() >> this.startPosition;
        int input = inData & this.calculateArrayOfOnes(this.numInputLines);
        if (this.numInputLines > this.numOutputLines) {
            if (this.seeHighBits) {
                this.out[0].setIntVal(input >>= this.numInputLines - this.numOutputLines);
            } else {
                int flag = this.calculateArrayOfOnes(this.numOutputLines);
                this.out[0].setIntVal(input &= flag);
            }
        }
        if (this.numInputLines < this.numOutputLines) {
            if (this.withSign) {
                int flagForSign = 1 << this.numInputLines - 1;
                if ((input & flagForSign) > 0) {
                    int pos = 1 << this.numInputLines;
                    int i = this.numInputLines;
                    while (i < this.numOutputLines) {
                        input |= pos;
                        pos <<= 1;
                        ++i;
                    }
                    this.out[0].setIntVal(input);
                } else {
                    this.out[0].setIntVal(input);
                }
            } else {
                this.out[0].setIntVal(input);
            }
        } else {
            this.out[0].setIntVal(input);
        }
    }

    private int calculateArrayOfOnes(int numOnes) {
        int flag = 1;
        int i = 1;
        while (i < numOnes) {
            flag <<= 1;
            flag |= 1;
            ++i;
        }
        return flag;
    }

    public static void main1(String[] args) {
        IntToInt iti = new IntToInt(16, 5);
        Pin p = new Pin("");
        p.setNumOfLines(16);
        p.setIsInt();
        p.setIntVal(163);
        iti.setInPin(0, p);
        iti.func();
        Log.errorLog("Izlaz je " + iti.getOutPin(0).getIntVal());
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }
}

