/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import java.util.LinkedList;
import java.util.List;
import logic.AbstractLogicComponent;
import logic.Pin;
import util.Element;
import util.ValidationElement;

public abstract class Gate
extends AbstractLogicComponent {
    public Gate() {
        this(2);
    }

    public Gate(int pinin) {
        super(pinin, 1);
    }

    public Gate(int in, String name) {
        super(in, 1);
        this.name = name;
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
        this.out[0].setName(args[args.length - 1]);
    }

    @Override
    public List<Element<String[], ValidationElement>> validateComponent(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        int size = 0;
        try {
            size = Integer.parseInt(data[2]);
            if (size <= 0) {
                ValidationElement vElement = new ValidationElement(3, "size < 0: size=" + size);
                Element<String[], ValidationElement> manjeOdMin = new Element<String[], ValidationElement>(data, vElement);
                result.add(manjeOdMin);
            } else if (size != data.length - 4) {
                ValidationElement vElement = new ValidationElement(3, "size != number of elements: size=" + size + ", number of elements=" + (data.length - 4));
                Element<String[], ValidationElement> manjeOdMin = new Element<String[], ValidationElement>(data, vElement);
                result.add(manjeOdMin);
            }
        }
        catch (Exception e) {
            ValidationElement vElement = new ValidationElement(3, "size is not a number: size=" + size);
            Element<String[], ValidationElement> err = new Element<String[], ValidationElement>(data, vElement);
            result.add(err);
        }
        return result;
    }

    @Override
    public List<Element<String[], ValidationElement>> validateConnection(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        int i = 0;
        while (i < this.in.length) {
            Pin inPin = this.in[i];
            if (inPin == null) {
                ValidationElement vElement = new ValidationElement(7, "Pin[" + i + "] not connected: " + data[i + 3]);
                Element<String[], ValidationElement> notConnected = new Element<String[], ValidationElement>(data, vElement);
                result.add(notConnected);
            }
            ++i;
        }
        return result;
    }
}

