/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import java.util.ArrayList;
import logic.AbstractLogicComponent;
import logic.Pin;
import logic.components.AND;
import logic.components.CLK;
import logic.components.DC;
import logic.components.IntToBools;
import logic.components.MP;
import logic.components.REG;

public class GPR
extends AbstractLogicComponent {
    private Pin clk;
    private int size;
    private ArrayList<REG> regs;
    private ArrayList<AND> ands;
    private IntToBools adressBits;
    private DC dekoder;
    private MP mx;

    public GPR(int numRegs, int regSize) {
        super(2, 1);
        this.size = numRegs;
        int numberOfPins = 0;
        if (numRegs != 0) {
            numberOfPins = (int)(Math.log(numRegs) / Math.log(2.0));
        }
        this.adressBits = new IntToBools(numberOfPins);
        this.out[0].setIsInt();
        this.out[0].setNumOfLines(regSize);
        this.dekoder = new DC(numberOfPins);
        this.dekoder.setE(new Pin(true, ""));
        int i = 0;
        while (i < numberOfPins) {
            this.dekoder.setInPin(i, this.adressBits.getOutPin(i));
            ++i;
        }
        this.mx = new MP(numRegs);
        this.mx.setOutPin(0, this.out[0]);
        i = 0;
        while (i < numberOfPins) {
            this.mx.setCtrl(i, this.adressBits.getOutPin(i));
            ++i;
        }
        this.regs = new ArrayList(numRegs);
        this.ands = new ArrayList(numRegs);
        i = 0;
        while (i < numRegs) {
            AND ldreg = new AND();
            ldreg.setInPin(0, this.dekoder.getOutPin(i));
            this.ands.add(ldreg);
            String name = "R" + i;
            REG r = new REG(1, name);
            r.getOutPin(0).setIsInt();
            r.getOutPin(0).setNumOfLines(regSize);
            r.setPinLd(ldreg.getOutPin(0));
            this.regs.add(r);
            this.mx.setInPin(i, r.getOutPin(0));
            ++i;
        }
    }

    @Override
    public void func() {
        if (this.clk != null && !this.clk.getBoolVal()) {
            return;
        }
        if (this.size > 0) {
            this.mx.func();
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setRead(Pin read) {
        read.addChild(this);
        this.mx.setE(read);
    }

    public void setWrite(Pin write) {
        int i = 0;
        while (i < this.size) {
            this.ands.get(i).setInPin(1, write);
            write.addChild(this.ands.get(i));
            ++i;
        }
    }

    public void setAdressPin(Pin adress) {
        this.in[0] = adress;
        this.adressBits.setInPin(0, adress);
        adress.addChild(this);
        adress.addChild(this.adressBits);
    }

    public void setInputDataPin(Pin datain) {
        this.in[1] = datain;
        int i = 0;
        while (i < this.size) {
            this.regs.get(i).setInPin(0, datain);
            datain.addChild(this.regs.get(i));
            ++i;
        }
    }

    public int read(int adress) {
        return this.regs.get(adress).getVal();
    }

    public REG getREG(int i) {
        return this.regs.get(i);
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }

    public void setClk(CLK clk) {
        this.clk = clk.getClk();
        this.period = clk.getPeriod();
        for (REG reg : this.regs) {
            reg.setClk(clk);
        }
    }
}

