/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.Execution;
import logic.Pin;
import logic.components.CLK;

public abstract class FF
extends AbstractLogicComponent {
    protected Pin clk;
    protected Pin reset;
    protected boolean init;
    protected boolean state;

    public FF(int inpins, String name) {
        super(inpins, 2, name, 1);
        Execution.addSequentialComponent(this);
    }

    @Override
    public abstract void func();

    public void setReset(Pin reset) {
        this.reset = reset;
        reset.addChild(this);
    }

    public void setClk(CLK clk) {
        this.clk = clk.getClk();
        this.period = clk.getPeriod();
    }

    @Override
    public void init(boolean fullInit) {
        this.state = this.init;
        this.setOutput();
    }

    public void setInit(boolean init) {
        this.state = init;
        this.init = init;
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }

    @Override
    public void propagate() {
        this.setOutput();
    }

    public void setOutput() {
        this.out[0].setBoolVal(this.state);
        this.out[1].setBoolVal(!this.state);
    }

    public int getState() {
        return this.state ? 1 : 0;
    }

    public void setState(int val) {
        this.state = val != 0;
        this.propagate();
    }
}

