/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import java.util.LinkedList;
import java.util.List;
import logic.AbstractLogicComponent;
import logic.Pin;
import util.Element;
import util.Log;
import util.ValidationElement;

public class DC
extends AbstractLogicComponent {
    private Pin E;

    public DC(int in) {
        super(in, (int)Math.pow(2.0, in));
    }

    @Override
    public void func() {
        int i;
        if (this.E != null && !this.E.getBoolVal()) {
            int i2 = 0;
            while (i2 < this.out.length) {
                this.out[i2].clear();
                ++i2;
            }
            return;
        }
        int index = 0;
        if (this.in[0].isBool()) {
            i = 0;
            while (i < this.in.length) {
                if (this.in[i].getBoolVal()) {
                    index += 1 << i;
                }
                ++i;
            }
        } else {
            index = this.in[0].getIntVal();
        }
        i = 0;
        while (i < this.out.length) {
            this.out[i].clear();
            ++i;
        }
        if (index < this.out.length) {
            this.out[index].setBoolVal(true);
        }
    }

    public void setE(Pin e) {
        this.E = e;
        e.addChild(this);
    }

    public Pin getE() {
        return this.E;
    }

    @Override
    public void initArgs(String[] args) {
        try {
            this.args = args;
            this.name = args[1];
            int i = 0;
            while (i < this.out.length) {
                Pin pin = this.out[i];
                String outName = args[4 + this.in.length + i];
                pin.setName(outName);
                ++i;
            }
        }
        catch (Exception e) {
            Log.errorLog("Wrong number of arguments on DC " + this.name + ". Expected " + (4 + this.out.length));
        }
    }

    @Override
    public List<Element<String[], ValidationElement>> validateComponent(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        int size = 0;
        try {
            size = Integer.parseInt(data[2]);
            if (size <= 0) {
                ValidationElement vElement = new ValidationElement(3, "size < 0: size=" + size);
                Element<String[], ValidationElement> manjeOdMin = new Element<String[], ValidationElement>(data, vElement);
                result.add(manjeOdMin);
            } else if (1 << size != data.length - 4 - size) {
                ValidationElement vElement = new ValidationElement(3, "2^size != number of elements: size=" + size + ", number of elements=" + (data.length - 4 - size));
                Element<String[], ValidationElement> manjeOdMin = new Element<String[], ValidationElement>(data, vElement);
                result.add(manjeOdMin);
            }
        }
        catch (Exception e) {
            ValidationElement vElement = new ValidationElement(3, "size is not a number: size=" + size);
            Element<String[], ValidationElement> err = new Element<String[], ValidationElement>(data, vElement);
            result.add(err);
        }
        return result;
    }

    @Override
    public List<Element<String[], ValidationElement>> validateConnection(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        int i = 0;
        while (i < this.in.length) {
            Pin inPin = this.in[i];
            if (inPin == null) {
                ValidationElement vElement = new ValidationElement(7, "Pin[" + i + "] not connected: " + data[i + 4]);
                Element<String[], ValidationElement> manjeOdMin = new Element<String[], ValidationElement>(data, vElement);
                result.add(manjeOdMin);
            }
            ++i;
        }
        if (this.E == null) {
            ValidationElement vElement = new ValidationElement(7, "Pin E not connected: ");
            Element<String[], ValidationElement> notConnected = new Element<String[], ValidationElement>(data, vElement);
            result.add(notConnected);
        }
        return result;
    }
}

