/*
 * Decompiled with CFR 0.152.
 */
package logic;

import java.util.ArrayList;
import java.util.List;
import logic.LogicComponent;
import util.TimeHistory;

public class Execution {
    public static int globalTime = 0;
    static List<LogicComponent> allSequentialComponents = new ArrayList<LogicComponent>();
    static List<LogicComponent> allComponents;
    static TimeHistory history;

    public static void nextCLK() {
        for (LogicComponent seq : allSequentialComponents) {
            seq.execute();
        }
        for (LogicComponent seq : allSequentialComponents) {
            seq.propagate();
        }
        ++globalTime;
        history.addClkState();
    }

    public static void init(boolean fullInit) {
        for (LogicComponent comp : allComponents) {
            comp.init(fullInit);
        }
        for (LogicComponent comp : allComponents) {
            comp.propagate();
        }
        globalTime = 0;
        history.clearHistory(0);
    }

    public static void setHistory(TimeHistory tdh) {
        history = tdh;
    }

    public static TimeHistory getHistory() {
        return history;
    }

    public static void addSequentialComponent(LogicComponent logcomp) {
        allSequentialComponents.add(logcomp);
    }

    public static List<LogicComponent> getSequentialComponent() {
        return allSequentialComponents;
    }

    public static List<LogicComponent> getComponent() {
        return allComponents;
    }

    public static void setComponent(List<LogicComponent> comps) {
        allComponents = comps;
    }

    public static void reset() {
        globalTime = 0;
        if (allSequentialComponents != null) {
            allSequentialComponents.clear();
        }
        if (allComponents != null) {
            allComponents.clear();
        }
    }
}

