/*
 * Decompiled with CFR 0.152.
 */
package gui.components;

import gui.Drawable;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import gui.components.AndGui;
import gui.components.DrawableComponentAbstract;
import gui.components.OrGui;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.TwoOne;

public class TwoOneGui
extends DrawableComponentAbstract {
    private static final int WIDTH = 200;
    OrGui orGui1;
    OrGui orGui2;
    AndGui andGui;
    LogicComponent left;
    LogicComponent right;
    LogicComponent center;

    public TwoOneGui(LogicComponent component, int x, int y, String[] args, boolean printInPortName, boolean printOutPortName) {
        super(component, x, y, args, printInPortName, printOutPortName);
        TwoOne tcmp = (TwoOne)component;
        this.left = tcmp.getLeft();
        this.right = tcmp.getRight();
        this.center = tcmp.getCenter();
        this.orGui1 = new OrGui(this.left, x, y, args, printInPortName, false);
        this.orGui2 = new OrGui(this.right, x, y + this.orGui1.getHeight() + 20, args, printInPortName, false);
        int centarY = (this.orGui1.getHeight() + this.orGui2.getHeight()) / 2;
        this.andGui = new AndGui(this.center, this.orGui1.getOutPortPosition((int)0).x - 65, y + centarY - 25, args, false, printOutPortName);
    }

    @Override
    public List<Drawable> getDrawables() {
        LinkedList<Drawable> gui = new LinkedList<Drawable>();
        gui.addAll(this.orGui1.getDrawables());
        gui.addAll(this.orGui2.getDrawables());
        gui.addAll(this.andGui.getDrawables());
        Point p1 = this.orGui1.getOutPortPosition(0);
        Point p2 = this.orGui2.getOutPortPosition(0);
        Point p3 = this.andGui.getInPortPosition(0);
        Point p4 = this.andGui.getInPortPosition(1);
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(p1.x, p1.y));
        points.add(new Point((p1.x + p3.x) / 2, p1.y));
        points.add(new Point((p1.x + p3.x) / 2, p3.y));
        points.add(new Point(p3.x, p3.y));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, this.left.getOutPin(0));
        this.drawables.add(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(p2.x, p2.y));
        points.add(new Point((p2.x + p4.x) / 2, p2.y));
        points.add(new Point((p2.x + p4.x) / 2, p4.y));
        points.add(new Point(p4.x, p4.y));
        sections.add(points);
        line = new GuiPinLine(sections, this.right.getOutPin(0));
        this.drawables.add(line);
        gui.addAll(this.drawables);
        return gui;
    }

    @Override
    public int getWidth() {
        return 200;
    }

    @Override
    public int getHeight() {
        int result = this.orGui1.getHeight() + 20 + this.orGui2.getHeight();
        return result;
    }

    protected static GuiTextLabel getLabel(Pin in, int x, int y) {
        String name = in.getName();
        if (name == null) {
            name = "";
        }
        GuiTextLabel label = new GuiTextLabel(TwoOneGui.moveString(name, 12, x), y, name, 12);
        return label;
    }

    private static int moveString(String text, int fontSize, int x) {
        int numChars = 2 * (text.length() + 1) / 3;
        int result = x - numChars * fontSize;
        return result;
    }

    @Override
    public Point getOutPortPosition(int index) {
        return this.andGui.getOutPortPosition(index);
    }

    @Override
    public Point getInPortPosition(int index) {
        return null;
    }
}

