/*
 * Decompiled with CFR 0.152.
 */
package gui.components;

import gui.Drawable;
import gui.GuiImageLabel;
import gui.GuiLine;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import gui.components.DrawableComponentAbstract;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;

public class OneOutGui
extends DrawableComponentAbstract {
    protected static final int WIDTH = 150;
    protected String imageURL;

    public OneOutGui(LogicComponent component, int x, int y, String[] args, boolean printInPortName, boolean printOutPortName, String imageURL) {
        super(component, x, y, args, printInPortName, printOutPortName);
        this.imageURL = imageURL;
    }

    @Override
    public List<Drawable> getDrawables() {
        String outName;
        GuiTextLabel label;
        GuiPinLine line;
        ArrayList<Point> points;
        ArrayList<List<Point>> sections;
        LinkedList<Drawable> gui = new LinkedList<Drawable>();
        int numberOfInputPins = this.component.getInPins().length;
        if (numberOfInputPins == 0) {
            return gui;
        }
        if (numberOfInputPins == 1) {
            String outName2;
            GuiTextLabel label2;
            ArrayList<List<Point>> sections2 = new ArrayList<List<Point>>();
            ArrayList<Point> points2 = new ArrayList<Point>();
            points2.add(new Point(this.x + 106 - 35, this.y + 20));
            points2.add(new Point(this.x + 146 - 35, this.y + 20));
            sections2.add(points2);
            GuiPinLine line2 = new GuiPinLine(sections2, this.component.getInPin(0));
            this.drawables.add(line2);
            if (this.printInPortName) {
                label2 = OneOutGui.getLabel(this.component.getInPin(0), this.x + 100 - 35, this.y + 20);
                this.drawables.add(label2);
            }
            if (this.printOutPortName && (outName2 = this.component.getName()) != null && !"".equals(outName2)) {
                label2 = new GuiTextLabel(this.x + 152 - 35, this.y + 20, outName2, 12);
                this.drawables.add(label2);
            }
            gui.addAll(this.drawables);
            return gui;
        }
        int i = 0;
        while (i < numberOfInputPins) {
            try {
                sections = new ArrayList();
                points = new ArrayList();
                points.add(new Point(this.x + 106 - 35, this.y + 20 + 15 * i));
                points.add(new Point(this.x + 113 - 35, this.y + 20 + 15 * i));
                sections.add(points);
                line = new GuiPinLine(sections, this.component.getInPin(i));
                this.drawables.add(line);
                if (this.printInPortName) {
                    label = OneOutGui.getLabel(this.component.getInPin(i), this.x + 100 - 33, this.y + 20 + 15 * i);
                    this.drawables.add(label);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        sections = new ArrayList<List<Point>>();
        points = new ArrayList<Point>();
        points.add(new Point(this.x + 136 - 35, this.y + 20 + 15 * (numberOfInputPins - 1) / 2));
        points.add(new Point(this.x + 146 - 35, this.y + 20 + 15 * (numberOfInputPins - 1) / 2));
        sections.add(points);
        line = new GuiPinLine(sections, this.component.getOutPin(0));
        this.drawables.add(line);
        if (this.printOutPortName && (outName = this.component.getOutPin(0).getName()) != null && !"".equals(outName)) {
            label = new GuiTextLabel(this.x + 152 - 35, this.y + 20 + 15 * numberOfInputPins / 2, outName, 12);
            this.drawables.add(label);
        }
        GuiImageLabel im = new GuiImageLabel(this.x + 79, this.y + 3 + 15 * numberOfInputPins / 2, this.imageURL);
        this.drawables.add(im);
        if (numberOfInputPins > 2) {
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(this.x + 114 - 35, this.y + 15));
            points.add(new Point(this.x + 114 - 35, this.y + 15 * numberOfInputPins / 2));
            sections.add(points);
            GuiLine upLine = new GuiLine(sections);
            this.drawables.add(upLine);
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(this.x + 114 - 35, this.y + 15 * numberOfInputPins / 2 + 20));
            points.add(new Point(this.x + 114 - 35, this.y + 5 + numberOfInputPins * 15 + 5));
            sections.add(points);
            upLine = new GuiLine(sections);
            this.drawables.add(upLine);
        }
        gui.addAll(this.drawables);
        return gui;
    }

    @Override
    public int getWidth() {
        String outName = this.component.getName();
        return Math.max(150, 117 + outName.length() * 10);
    }

    @Override
    public int getHeight() {
        int numberOfInputPins = this.component.getInPins().length;
        return 20 + (numberOfInputPins - 1) * 15 + 20;
    }

    protected static GuiTextLabel getLabel(Pin in, int x, int y) {
        String name = null;
        if (in == null) {
            name = "null";
        } else {
            name = in.getName();
            if (name == null) {
                name = "";
            }
        }
        GuiTextLabel label = new GuiTextLabel(x, y, name, 12, 1);
        return label;
    }

    @Override
    public Point getOutPortPosition(int index) {
        int numberOfInputPins = this.component.getInPins().length;
        Point result = new Point(this.x + 146 - 35, this.y + 20 + 15 * (numberOfInputPins - 1) / 2);
        return result;
    }

    @Override
    public Point getInPortPosition(int index) {
        int numberOfInputPins = this.component.getInPins().length;
        if (numberOfInputPins == 0) {
            return null;
        }
        if (numberOfInputPins == 1) {
            return new Point(this.x + 106 - 35, this.y + 20);
        }
        return new Point(this.x + 106 - 35, this.y + 20 + 15 * index);
    }
}

