/*
 * Decompiled with CFR 0.152.
 */
package gui.components;

import gui.Drawable;
import gui.GuiLine;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import gui.components.DrawableComponentAbstract;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.components.DC;

public class DCGui
extends DrawableComponentAbstract {
    private static final int DCWIDTH = 180;
    Point[] inPortPositions;
    Point[] outPortPositions;
    private static final int DISTANCE = 15;

    public DCGui(DC dc, int x, int y, String[] args, boolean printOutPortName) {
        this(dc, x, y, args, true, printOutPortName);
    }

    public DCGui(DC dc, int x, int y, String[] args, boolean printInPortName, boolean printOutPortName) {
        super(dc, x, y, args, printInPortName, printOutPortName);
        this.inPortPositions = new Point[dc.getInPins().length];
        this.outPortPositions = new Point[dc.getOutPins().length];
    }

    @Override
    public List<Drawable> getDrawables() {
        GuiPinLine line;
        LinkedList<Drawable> gui = new LinkedList<Drawable>();
        DC dc = (DC)this.component;
        int inNum = dc.getInPins().length;
        int outNum = (int)Math.pow(2.0, inNum);
        int heihgt = (outNum + 1) * 15;
        GuiTextLabel label = new GuiTextLabel(this.x + 54, this.y + this.getYMargin(inNum) + heihgt / 2, this.args[1], 14);
        this.drawables.add(label);
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(this.x + 39, this.y + this.getYMargin(inNum)));
        points.add(new Point(this.x + 95, this.y + this.getYMargin(inNum)));
        points.add(new Point(this.x + 95, this.y + this.getYMargin(inNum) + heihgt));
        points.add(new Point(this.x + 39, this.y + this.getYMargin(inNum) + heihgt));
        points.add(new Point(this.x + 39, this.y + this.getYMargin(inNum)));
        sections.add(points);
        this.drawables.add(new GuiLine(sections));
        int startI0 = this.getYMargin(inNum) + heihgt / 2 + inNum * 15 / 2;
        int i = 0;
        while (i < inNum) {
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(this.x - 50 + 82, this.y + startI0));
            points.add(new Point(this.x - 50 + 89, this.y + startI0));
            sections.add(points);
            line = new GuiPinLine(sections, dc.getInPin(i));
            this.drawables.add(line);
            this.inPortPositions[i] = new Point(this.x - 50 + 89, this.y + startI0);
            label = new GuiTextLabel(this.x - 50 + 94, this.y + startI0, "" + i, 10);
            this.drawables.add(label);
            label = new GuiTextLabel(this.x + 28, this.y + startI0, this.args[4 + i], 13, 1);
            this.drawables.add(label);
            startI0 -= 15;
            ++i;
        }
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(this.x - 50 + 117, this.y + this.getYEnd(inNum)));
        points.add(new Point(this.x - 50 + 117, this.y + this.getYEnd(inNum) + 8));
        sections.add(points);
        line = new GuiPinLine(sections, dc.getE());
        this.drawables.add(line);
        label = new GuiTextLabel(this.x - 50 + 116, this.y + this.getYEnd(inNum) - 6, "E", 10);
        this.drawables.add(label);
        label = new GuiTextLabel(this.x + 68, this.y + this.getYEnd(inNum) + 22, this.args[3], 13, 2);
        this.drawables.add(label);
        startI0 = this.getYEnd(inNum) - 15;
        i = 0;
        while (i < outNum) {
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(this.x - 50 + 145, this.y + startI0));
            points.add(new Point(this.x - 50 + 151, this.y + startI0));
            sections.add(points);
            line = new GuiPinLine(sections, dc.getOutPin(i));
            this.drawables.add(line);
            this.outPortPositions[i] = new Point(this.x - 50 + 151, this.y + startI0);
            label = new GuiTextLabel(this.x - 50 + 135, this.y + startI0 + 2, "" + i, 10);
            this.drawables.add(label);
            if (this.printOutPortName) {
                label = new GuiTextLabel(this.x - 50 + 155, this.y + startI0 + 2, this.args[4 + inNum + i], 13);
                this.drawables.add(label);
            }
            startI0 -= 15;
            ++i;
        }
        gui.addAll(this.drawables);
        return gui;
    }

    @Override
    public int getWidth() {
        return 180;
    }

    @Override
    public int getHeight() {
        int max = this.component.getOutPins().length;
        if (max <= 8) {
            return 180;
        }
        return 180 * max / 8;
    }

    protected int getYMargin(int n) {
        if (n == 2) {
            return 46;
        }
        return 18;
    }

    protected int getYEnd(int n) {
        int result = this.getYMargin(n);
        return result += ((int)Math.pow(2.0, n) + 1) * 15;
    }

    @Override
    public Point getOutPortPosition(int index) {
        if (index >= 0 && index < this.outPortPositions.length) {
            return this.outPortPositions[index];
        }
        return null;
    }

    @Override
    public Point getInPortPosition(int index) {
        if (index >= 0 && index < this.inPortPositions.length) {
            return this.inPortPositions[index];
        }
        return null;
    }
}

