/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;
import java.util.List;
import util.DrawUtils;

public class GuiTextLabel
implements Drawable {
    public static final String DEFAULTFONT = "Times New Roman";
    public static final int DEFAULTSTILE = 0;
    public static final Color DEFAULTCOLOR = Color.BLACK;
    protected int x;
    protected int y;
    protected String label;
    int fontSize;
    String fontName;
    int fontStyle;
    Color fontColor;
    double angle;

    public GuiTextLabel(int x, int y, String label, int alignment, int fontSize, String fontName, int fontStyle, Color fontColor, double angle) {
        this.x = DrawUtils.calcX(x, label, alignment, fontSize, fontName, fontStyle);
        this.y = y;
        this.label = label;
        this.fontSize = fontSize;
        this.angle = angle;
        this.fontName = fontName;
        this.fontStyle = fontStyle;
        this.fontColor = fontColor;
        this.rotate();
    }

    public GuiTextLabel(int x, int y, String label, int fontSize, int alignment, double angle) {
        this(x, y, label, alignment, fontSize, DEFAULTFONT, 0, DEFAULTCOLOR, angle);
    }

    public GuiTextLabel(int x, int y, String label, int fontSize, int alignment) {
        this(x, y, label, fontSize, alignment, 0.0);
    }

    public GuiTextLabel(int x, int y, String label, int fontSize) {
        this(x, y, label, fontSize, 0, 0.0);
    }

    public GuiTextLabel(int x, int y, String label, int fontSize, double angle) {
        this(x, y, label, fontSize, 0, angle);
    }

    private void rotate() {
        double xP = (double)this.x * Math.cos(this.angle) + (double)this.y * Math.sin(this.angle);
        double yP = (double)(-this.x) * Math.sin(this.angle) + (double)this.y * Math.cos(this.angle);
        this.x = (int)xP;
        this.y = (int)yP;
    }

    @Override
    public void draw(Graphics g) {
        this.update();
        Color c = g.getColor();
        Font f = g.getFont();
        g.setColor(this.fontColor);
        g.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
        if (this.angle == 0.0) {
            g.drawString(this.label, this.x, this.y);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform orig = g2.getTransform();
            g2.rotate(this.angle);
            g.drawString(this.label, this.x, this.y);
            g2.setTransform(orig);
        }
        g.setFont(f);
        g.setColor(c);
    }

    @Override
    public void update() {
    }

    @Override
    public int getWidth() {
        return DrawUtils.stringWidth(this.label, this.fontSize, this.fontName, this.fontStyle);
    }

    @Override
    public int getHeight() {
        return DrawUtils.stringHeight(this.label, this.fontSize, this.fontName, this.fontStyle);
    }

    @Override
    public Point getCorner(int corner) {
        switch (corner) {
            case 0: {
                return new Point(this.x, this.y - this.getHeight());
            }
            case 1: {
                return new Point(this.x + this.getWidth(), this.y - this.getHeight());
            }
            case 2: {
                return new Point(this.x, this.y);
            }
            case 3: {
                return new Point(this.x + this.getWidth(), this.y);
            }
        }
        return null;
    }

    @Override
    public List<Drawable> getDrawables() {
        LinkedList<Drawable> result = new LinkedList<Drawable>();
        return result;
    }
}

