/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GuiLine;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import logic.Pin;

public class GuiPinLine
extends GuiLine {
    protected Pin pin;

    public GuiPinLine(List<List<Point>> sections, Pin pin) {
        this(sections, pin, GuiPinLine.convertToSize(pin));
    }

    public GuiPinLine(List<List<Point>> sections, Pin pin, float size) {
        super(sections, Color.BLACK, size);
        this.pin = pin;
    }

    @Override
    public void update() {
        this.color = this.pin.isHighZ() ? Color.GREEN : (this.pin.isBool() ? (this.pin.getBoolVal() ? Color.RED : Color.BLUE) : Color.GRAY);
    }

    private static float convertToSize(Pin pin) {
        if (pin == null) {
            return 1.0f;
        }
        int numberOfLines = pin.getNumOfLines();
        if (numberOfLines <= 1) {
            return 1.0f;
        }
        if (numberOfLines <= 4) {
            return 1.5f;
        }
        if (numberOfLines <= 8) {
            return 2.0f;
        }
        if (numberOfLines <= 16) {
            return 2.5f;
        }
        return 3.0f;
    }

    public Pin getPin() {
        return this.pin;
    }

    public void setPin(Pin pin) {
        this.pin = pin;
    }
}

