/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class GuiLine
implements Drawable {
    protected List<List<Point>> sections;
    protected Color color;
    protected float size;

    public GuiLine(List<List<Point>> sections) {
        this(sections, Color.BLACK, 1.0f);
    }

    public GuiLine(int[][] sections, Color color, float size) {
        this.color = color;
        this.sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        int[][] nArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            int[] section = nArray[n2];
            if (section.length == 2) {
                points.add(new Point(section[0], section[1]));
            }
            ++n2;
        }
        this.sections.add(points);
        this.size = size;
    }

    public GuiLine(List<List<Point>> sections, Color color, float size) {
        this.sections = sections;
        this.color = color;
        this.size = size;
    }

    @Override
    public void draw(Graphics g) {
        this.update();
        Graphics2D g2d = (Graphics2D)g;
        Stroke stroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(this.size));
        Color col = g2d.getColor();
        g2d.setColor(this.color);
        for (List<Point> section : this.sections) {
            Point last = null;
            for (Point p : section) {
                if (last != null) {
                    g2d.drawLine(last.x, last.y, p.x, p.y);
                    if (last.x == p.x) {
                        g2d.drawLine(last.x + 1, last.y, p.x + 1, p.y);
                    }
                    if (last.y == p.y) {
                        g2d.drawLine(last.x, last.y + 1, p.x, p.y + 1);
                    }
                }
                last = p;
            }
        }
        g2d.setStroke(stroke);
        g2d.setColor(col);
    }

    @Override
    public void update() {
    }

    @Override
    public int getWidth() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (List<Point> section : this.sections) {
            for (Point p : section) {
                if (minX > p.x) {
                    minX = p.x;
                }
                if (maxX >= p.x) continue;
                maxX = p.x;
            }
        }
        return maxX - minX;
    }

    @Override
    public int getHeight() {
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (List<Point> section : this.sections) {
            for (Point p : section) {
                if (minY > p.y) {
                    minY = p.y;
                }
                if (maxY >= p.y) continue;
                maxY = p.y;
            }
        }
        return maxY - minY;
    }

    @Override
    public Point getCorner(int corner) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (List<Point> section : this.sections) {
            for (Point p : section) {
                if (minX > p.x) {
                    minX = p.x;
                }
                if (maxX < p.x) {
                    maxX = p.x;
                }
                if (minY > p.y) {
                    minY = p.y;
                }
                if (maxY >= p.y) continue;
                maxY = p.y;
            }
        }
        switch (corner) {
            case 0: {
                return new Point(minX, minY);
            }
            case 1: {
                return new Point(maxX, minY);
            }
            case 2: {
                return new Point(minX, maxY);
            }
            case 3: {
                return new Point(maxX, maxY);
            }
        }
        return null;
    }

    @Override
    public List<Drawable> getDrawables() {
        LinkedList<Drawable> result = new LinkedList<Drawable>();
        return result;
    }
}

