/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Drawable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.ImageIcon;
import util.Log;

public class GuiImageLabel
implements Drawable {
    protected int x;
    protected int y;
    protected String imageURL;
    protected Image image;
    protected int width;
    protected int height;

    public GuiImageLabel(int x, int y, String imageURL) {
        this.x = x;
        this.y = y;
        this.imageURL = imageURL;
        try {
            if (imageURL != null) {
                ImageIcon icon = new ImageIcon(imageURL);
                this.image = icon.getImage();
                this.width = this.image.getWidth(null);
                this.height = this.image.getHeight(null);
            }
        }
        catch (Exception e) {
            Log.errorLog(e, "Immage " + imageURL);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.image != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(this.image, this.x, this.y, this.width, this.height, null);
        }
    }

    @Override
    public void update() {
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Point getCorner(int corner) {
        switch (corner) {
            case 0: {
                return new Point(this.x, this.y - this.getHeight());
            }
            case 1: {
                return new Point(this.x + this.getWidth(), this.y - this.getHeight());
            }
            case 2: {
                return new Point(this.x, this.y);
            }
            case 3: {
                return new Point(this.x + this.getWidth(), this.y);
            }
        }
        return null;
    }

    @Override
    public List<Drawable> getDrawables() {
        return null;
    }
}

