﻿Shader "RG2/12_AtlasShader"
{
	Properties
	{
		_AtlasTex ("Atlas", 2D) = "white" {}
	}

	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			#pragma glsl	// this is needed, because OpenGL profile is needed to compute uv-space derivates.
			#pragma target 3.0		
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 uv : TEXCOORD0;
			};
			
			sampler2D _AtlasTex;
			float4 _AtlasTex_ST;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.uv = v.uv*10;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				float2 uv = _AtlasTex_ST.zw + frac(i.uv) * _AtlasTex_ST.xy;
				float2 continuousUV = _AtlasTex_ST.zw + i.uv * _AtlasTex_ST.xy;
				//fixed4 color = tex2D(_AtlasTex, uv);
				fixed4 color = tex2D(_AtlasTex, uv, ddx(continuousUV), ddy(continuousUV));
				return color;
			}
			ENDCG
		}
	}
}
