﻿Shader "RG2/11_ShadowShader"
{
	Properties
	{
		_ShadowMap ("ShadowMap", 2D) = "white" {}
	}

	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 vertexPosInShadowMap : TEXCOORD0;
				float depthR : TEXCOORD1;
			};
			
			float3 LightPos;
			float2 LightParams;	// x = near, y = 1/(far - near);
			float4x4 LightVP;
			sampler2D _ShadowMap;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				float4 vertexWorldPos = mul(unity_ObjectToWorld, v.vertex);
				float dist = (length(vertexWorldPos.xyz - LightPos) - LightParams.x) * LightParams.y;
				o.depthR = dist;
				
				float4 vertexInCameraProjectionSpace = mul(LightVP, vertexWorldPos);
				o.vertexPosInShadowMap = 
					(vertexInCameraProjectionSpace.xy / vertexInCameraProjectionSpace.w) * 0.5 + 0.5;
				
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				fixed4 col = fixed4(1,1,1,1);
				float depthInShadowMap = tex2D(_ShadowMap, i.vertexPosInShadowMap).r;
				
				if( i.depthR - depthInShadowMap > 0 )
					col *= fixed4(0.5,0.5,0.5,1);
				return col;
				
			}
			ENDCG
		}
	}
}
