﻿Shader "RG2/11_ShadowMapShader"
{
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float depthR : TEXCOORD0;
			};
			
			float3 LightPos;
			float2 LightParams;	// x = near, y = 1/(far - near);
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				float4 vertexWorldPos = mul(unity_ObjectToWorld, v.vertex);
				float dist = (length(vertexWorldPos.xyz - LightPos) - LightParams.x) * LightParams.y;
				o.depthR = dist;
				return o;
			}
			
			float4 frag (v2f i) : SV_Target
			{
				return float4(i.depthR, 0, 0, 0);
			}
			ENDCG
		}
	}
}
