﻿Shader "RG2/09_DownsampleShader"
{
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 screenPos : TEXCOORD0;
			};

			sampler2D _MainTex;
			// x=1/width, y=1/height, z=width, w=height
			float4 _MainTex_TexelSize;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.screenPos = (o.vertex.xy/o.vertex.w)*0.5+0.5;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{			
				float2 delta = _MainTex_TexelSize.xy;
				float2 uvMain = float2(i.screenPos.x, 1-i.screenPos.y);
				half4 sample1 = tex2D(_MainTex, uvMain + delta*float2(0.5,0.5));
				half4 sample2 = tex2D(_MainTex, uvMain + delta*float2(-0.5,0.5));
				half4 sample3 = tex2D(_MainTex, uvMain + delta*float2(0.5,-0.5));
				half4 sample4 = tex2D(_MainTex, uvMain + delta*float2(-0.5,-0.5));
				
				return (sample1+sample2+sample3+sample4)*0.25;
			}
			ENDCG
		}
	}
}
