﻿Shader "RG2/09_DoFShader"
{
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 screenPos : TEXCOORD0;
			};

			sampler2D _MainTex;
			sampler2D _DownsampledTex;
			float4 _DownsampledTex_TexelSize;
			sampler2D _CameraDepthTexture;
			float FocalDistance;
			float FocusRange;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.screenPos = (o.vertex.xy/o.vertex.w)*0.5+0.5;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				float2 uv = i.screenPos.xy;
				float2 uvInverted = float2(i.screenPos.x, 1-i.screenPos.y);
				fixed4 depth = tex2D(_CameraDepthTexture, uv);
				fixed4 mainColor = tex2D(_MainTex, uvInverted);

				float zDist = (FocalDistance-_ProjectionParams.y)/(_ProjectionParams.z-_ProjectionParams.y);
				float offFocus = pow(abs(depth.r-zDist), FocusRange);
				
				float2 delta = _DownsampledTex_TexelSize.xy;
				
				half4 blurSample1 = tex2D(_DownsampledTex, uvInverted + delta*float2(0.5,0.5));
				half4 blurSample2 = tex2D(_DownsampledTex, uvInverted + delta*float2(-0.5,0.5));
				half4 blurSample3 = tex2D(_DownsampledTex, uvInverted + delta*float2(0.5,-0.5));
				half4 blurSample4 = tex2D(_DownsampledTex, uvInverted + delta*float2(-0.5,-0.5));

				fixed4 blurColor = (blurSample1+blurSample2+blurSample3+blurSample4)*0.25;
	
				return lerp(mainColor, blurColor, offFocus);
			}
			ENDCG
		}
	}
}
