﻿Shader "RG2/07_BlurShader"
{
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 screenPos : TEXCOORD0;
			};

			sampler2D _MainTexture;
			// x=1/width, y=1/height, z=width, w=height
			float4 _MainTexture_TexelSize;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.screenPos = (o.vertex.xy/o.vertex.w)*0.5+0.5;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				int filterSize = 5;
				int maxSteps = 11;
				float divisor = 121;

				float2 uv = i.screenPos - filterSize*_MainTexture_TexelSize.xy;
				float4 color = float4(0,0,0,0);
				for(int i = 0; i < maxSteps; i++)
				{
					for(int j = 0; j < maxSteps; j++)
					{
						float4 tmp = tex2D(_MainTexture, uv + float2(_MainTexture_TexelSize.x*j, _MainTexture_TexelSize.y*i)) + 0.35;
						color += tmp*tmp*tmp;
					}
				}

				return fixed4(color.rgb/divisor, 1);				
			}
			ENDCG
		}
	}
}
