﻿Shader "RG2/07_BloomShader"
{
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 screenPos : TEXCOORD0;
			};

			sampler2D _MainTexture;
			sampler2D _BlurTexture;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.screenPos = (o.vertex.xy/o.vertex.w)*0.5+0.5;
				o.screenPos.y = o.screenPos.y;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{			
				float2 uvMain = float2(i.screenPos.x, 1-i.screenPos.y);
				float2 uvBlur = i.screenPos;
				fixed4 mainColor = tex2D(_MainTexture, uvMain);
				fixed4 bloomColor = tex2D(_BlurTexture, uvBlur);
				
				float factor = dot(fixed3(0.33, 0.33, 0.33),bloomColor.rgb);

				return max(mainColor, lerp(mainColor, bloomColor, factor));
			}
			ENDCG
		}
	}
}
