﻿Shader "RG2/06_GlassShader"
{
	Properties
	{
		_CubeMap ("Cube map", CUBE) = "white" {}
		_Transparency("Transparency", Range(0, 1)) = 1.0
	}
	SubShader
	{
		Tags {  "Queue" = "Transparent" "LightMode"="ForwardBase" }
		
		Blend SrcAlpha OneMinusSrcAlpha
		ZWrite off

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float3 normal : NORMAL;
			};

			struct v2f
			{
				float3 normal : NORMAL;
				float3 vertexPosInObjSpace : TEXCOORD0;
				float4 vertex : SV_POSITION;
			};

			samplerCUBE _CubeMap;
			float _Transparency;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.normal = v.normal;
				o.vertexPosInObjSpace = v.vertex;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				float3 viewDir = normalize(ObjSpaceViewDir(float4(i.vertexPosInObjSpace, 1))).xyz;
				float3 uv = reflect( -viewDir, normalize(i.normal));
				uv = mul(UNITY_MATRIX_M, float4(uv, 0));
				fixed4 col = texCUBE(_CubeMap, uv);
				col.a = (1-dot(viewDir, i.normal))*(1-_Transparency);
				return col;
			}
			ENDCG
		}
	}
}
