﻿Shader "RG2/05_ViewPaint"
{
	Properties
	{
		_MainTex ("Main", 2D) = "white" {}
		_PaintTex ("Paint", 2D) = "white" {}
	}
	SubShader
	{
		Tags { "RenderType"="Opaque" "LightMode"="ForwardBase" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 uv : TEXCOORD0;
			};

			sampler2D _MainTex;
			sampler2D _PaintTex;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.uv = v.uv;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				fixed4 main = tex2D(_MainTex, i.uv);
				fixed4 paint = tex2D(_PaintTex, i.uv);
				
				return fixed4(lerp(main.rgb, paint.rgb, paint.a), 1.0);
				//return fixed4(paint.rgb, 1.0);
			}

			ENDCG
		}
	}
}
