﻿Shader "RG2/05_PaintShader"
{
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		//Blend SrcAlpha OneMinusSrcAlpha
		BlendOp Add, max
		//Cull Off

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 screenCoord : TEXCOORD0;
			};

			float4 center;
			float radius;

			v2f vert (appdata v)
			{	
				v2f o;
				float4 pom;
				float4 vertexInHCS = UnityObjectToClipPos(v.vertex);
				o.vertex = float4((v.uv-0.5)*2, 0, 1);
				o.screenCoord = vertexInHCS.xy / vertexInHCS.w;
				return o;
			
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				float2 dist = i.screenCoord - center.xy;
				float dist2 = dot(dist, dist);

				float alpha = 1 - dist2 / (radius*radius);
				
				fixed4 col = fixed4(1, 1, 1, alpha);

				return col;
			}
			ENDCG
		}
	}
}
