﻿Shader "RG2/04_BumpShader" {
    Properties {
        _MainTex ("Base (RGB)", 2D) = "white" {}
        _Bump ("Bump", 2D) = "bump" {}
    }
    SubShader {
        Tags { "RenderType"="Opaque" "LightMode"="ForwardBase" }
        LOD 200

        Pass {

            Cull Back 
            Lighting On

            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag

            #include "UnityCG.cginc"

            sampler2D _MainTex;
            sampler2D _Bump;

            struct app2v {
                float4 vertex : POSITION;
                float3 normal : NORMAL;
                float4 texcoord : TEXCOORD0;
                float4 tangent : TANGENT;
            }; 

            struct v2f {
                float4 pos : POSITION;
                float2 uv : TEXCOORD0;
                float3 lightDirection : TEXCOORD1;
            };

            v2f vert (app2v v) {
                v2f o;
                TANGENT_SPACE_ROTATION; 

                o.lightDirection = mul(rotation, ObjSpaceLightDir(v.vertex));
                o.pos = UnityObjectToClipPos(v.vertex); 
                o.uv = v.texcoord;  
                return o;
            }

            fixed4 frag(v2f i) : COLOR { 
                float4 c = tex2D (_MainTex, i.uv);  
                float3 n =  UnpackNormal(tex2D (_Bump, i.uv)); 

                float diff = saturate (dot (n, normalize(i.lightDirection)));   
                c.rgb = diff * c.rgb;
				return c; 
			} 
             ENDCG
        }
    }
}