﻿Shader "RG2/03_Atmosphere"
{
	Properties
	{
		DayColor ("Day", Color) = (0,0.7,1)
		SunsetColor ("Sunset", Color) = (1, 0.5, 0)
	}
	SubShader
	{
		Tags { "RenderType"="Opaque" "LightMode"="ForwardBase" }

		Blend SrcAlpha OneMinusSrcAlpha
		
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float3 normal : NORMAL;
			};

			struct v2f
			{
				float3 normal : NORMAL;
				float4 vertex : SV_POSITION;
				float3 lightDir : TEXCOORD1;
				float3 viewDir : TEXCOORD2;
			};
		
			fixed4 DayColor;
			fixed4 SunsetColor;
		
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.normal = UnityObjectToWorldNormal(v.normal);
				
				float3 worldPos = mul(unity_ObjectToWorld, v.vertex).xyz;
				o.lightDir = normalize(UnityWorldSpaceLightDir(worldPos));
				o.viewDir = normalize(_WorldSpaceCameraPos.xyz - worldPos.xyz);
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{			
				float3 normal = normalize(i.normal);
				float3 lightDir = normalize(i.lightDir);
				
				
				float lambert = max(0, dot(normal, lightDir));
				float alpha = (1 - dot(i.viewDir, normal)) * lambert;
				
				return fixed4(lerp(SunsetColor.rgb, DayColor.rgb, lambert), alpha);
			}

			ENDCG
		}
	}
}
