﻿Shader "RG2/02_SpecularShader"
{
	Properties
	{
		_MainTex ("Texture", 2D) = "white" {}
	}
	SubShader
	{
		Tags { "RenderType"="Opaque" "LightMode" = "ForwardBase" }
		LOD 100

		Pass
		{		
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"
			#include "Lighting.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float3 normal : NORMAL;
				float2 uv : TEXCOORD0;
			};

			struct v2f
			{
				float2 uv : TEXCOORD0;
				float3 normal : NORMAL;
				float4 vertex : SV_POSITION;
				float3 lightDir : TEXCOORD1;
				float3 viewDir : TEXCOORD2;
			};

			sampler2D _MainTex;
			float4 WorldSpaceLightPos;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.normal = UnityObjectToWorldNormal(v.normal);
				
				float3 worldPos = mul(unity_ObjectToWorld, v.vertex).xyz;
				o.lightDir = normalize(UnityWorldSpaceLightDir(worldPos));
				o.viewDir = normalize(_WorldSpaceCameraPos.xyz - worldPos.xyz);
				o.uv = v.uv;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				fixed4 col = tex2D(_MainTex, i.uv);
				float3 normal = normalize(i.normal);
				float3 lightDir = normalize(i.lightDir);
				float lambert = max(0,dot(normal, lightDir));
				float3 reflection = reflect(-lightDir, normal);
				float specular = pow(max(0,dot(normalize(i.viewDir), reflection)), 25);
				return fixed4(col.rgb*lambert + fixed3(specular, specular, specular), 1.0);
			}
			ENDCG
		}
	}
}
