﻿using UnityEngine;
using System.Collections;

public class L11_ShadowCamera : MonoBehaviour {

	[SerializeField]
	private Shader ShadowMapShader;


	private GameObject Light;
	private Camera shadowMapCamera;

	// Use this for initialization
	void Start () {

		shadowMapCamera = GetComponent<Camera>();
		shadowMapCamera.SetReplacementShader(ShadowMapShader,"");

		Light = GameObject.Find("Directional Light");
	}
	
	// Update is called once per frame
	void Update () 
	{
		Vector4 position = Light.transform.position;
		position.w = 1;
		Shader.SetGlobalVector("LightPos", position);

		Vector2 lightParams = new Vector2( shadowMapCamera.near, 1.0f/(shadowMapCamera.far-shadowMapCamera.near) );
		Shader.SetGlobalVector("LightParams", lightParams);

		Matrix4x4 LightVP = shadowMapCamera.projectionMatrix * shadowMapCamera.worldToCameraMatrix;
		Shader.SetGlobalMatrix("LightVP", LightVP);
	}
}
