﻿using UnityEngine;
using System.Collections;

public class L07_Blur : MonoBehaviour {

	[SerializeField]
	private Shader BlurShader;

	Material m_Material = null;
	protected Material material
	{
		get
		{
			if (m_Material == null)
			{
				m_Material = new Material(BlurShader);
				m_Material.hideFlags = HideFlags.DontSave;
			}
			return m_Material;
		}
	}

	protected void OnDisable()
	{
		if (m_Material)
		{
			DestroyImmediate(m_Material);
		}
	}

	void OnRenderImage(RenderTexture src, RenderTexture dst)
	{
		int rtW = src.width / 4;
		int rtH = src.height / 4;
		RenderTexture buffer = RenderTexture.GetTemporary(rtW, rtH, 0);

		material.SetTexture("_MainTexture", src);
		Graphics.Blit(src, buffer, material);

		material.SetTexture("_MainTexture", buffer);
		Graphics.Blit(buffer, dst, material);

		RenderTexture.ReleaseTemporary(buffer);
	}
}
