﻿using UnityEngine;
using System.Collections;

public class L07_Bloom : MonoBehaviour {

	[SerializeField]
	private RenderTexture BlurTexture;

	[SerializeField]
	private Shader BloomShader;

	static Material m_Material = null;
	protected Material material
	{
		get
		{
			if (m_Material == null)
			{
				m_Material = new Material(BloomShader);
				m_Material.hideFlags = HideFlags.DontSave;
			}
			return m_Material;
		}
	}

	protected void OnDisable()
	{
		if (m_Material)
		{
			DestroyImmediate(m_Material);
		}
	}

	void OnRenderImage(RenderTexture src, RenderTexture dst)
	{
		material.SetTexture("_MainTexture", src);
		material.SetTexture("_BlurTexture", BlurTexture);
		Graphics.Blit(src, dst, material);
	}
}
