﻿// Upgrade NOTE: replaced '_Object2World' with 'unity_ObjectToWorld'

Shader "RG2/Ispit/RotateUV_Ring"
{
	Properties
	{
		_MainTex ("Texture", 2D) = "white" {}
	}
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 100

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 uv : TEXCOORD0;
			};

			sampler2D _MainTex;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);

				o.uv =  mul(unity_ObjectToWorld, v.vertex).xy;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{

				float distance = length(i.uv);
				float inRing = distance > 1.0 && distance < 2.5;
				float2x2 mat = float2x2( cos(_Time.y), -sin(_Time.y), sin(_Time.y), cos(_Time.y) );
				float2 uv = i.uv * (1-inRing) + inRing * mul(mat, i.uv);

				fixed4 col = tex2D(_MainTex, uv);
				return col;
			}
			ENDCG
		}
	}
}
