﻿Shader "RG2/Ispit/RotateUV"
{
	Properties
	{
		_MainTex ("Texture", 2D) = "white" {}
	}
	SubShader
	{		
		Pass
		{
		
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
			};

			struct v2f
			{
				float4 vertex : SV_POSITION;
				float2 uv : TEXCOORD0;
				float2 xy : TEXCOORD1;
			};

			sampler2D _MainTex;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				float a = cos(_Time.z);
				float b = sin(_Time.z);
				float2x2 mat = float2x2(a, b, -b, a);
				o.uv = mul(mat, (v.uv - 0.5)) + 0.5;
				o.xy = (o.vertex.xy/o.vertex.w)*0.5 + 0.5;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				fixed4 col = tex2D(_MainTex, i.uv);
				return col * fixed4(1, i.xy, 1);
			}
			ENDCG
		}
	}
}
