﻿Shader "RG2/Ispit/SinkHole"
{
	Properties
	{
		_MainTex ("Texture", 2D) = "white" {}
	}
	SubShader
	{
		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			
			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
			};

			struct v2f
			{
				float2 posInWorld: TEXCOORD0;
				float4 vertex : SV_POSITION;
			};

			sampler2D _MainTex;
			
			v2f vert (appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.posInWorld = mul(unity_ObjectToWorld, v.vertex).xz;
				return o;
			}
			
			fixed4 frag (v2f i) : SV_Target
			{
				float dist = length(i.posInWorld) + abs(sin(_Time.z));
				float2 uv = i.posInWorld * dist;

				fixed4 col = tex2D(_MainTex, uv);
				return col;
			}
			ENDCG
		}
	}
}
