﻿using UnityEngine;
using System.Collections;

public class ProceduralCube : MonoBehaviour {

	void Start () {
		Vector3[] vert = new Vector3[24];
		vert[0] = new Vector3(-1, -1, -1);
		vert[1] = new Vector3(1, -1, -1);
		vert[2] = new Vector3(1, 1, -1);
		vert[3] = new Vector3(-1, 1, -1);

		vert[4] = new Vector3(1, -1, -1);
		vert[5] = new Vector3(1, -1, 1);
		vert[6] = new Vector3(1, 1, 1);
		vert[7] = new Vector3(1, 1, -1);

		vert[8] = new Vector3(1, -1, 1);
		vert[9] = new Vector3(-1, -1, 1);
		vert[10] = new Vector3(-1, 1, 1);
		vert[11] = new Vector3(1, 1, 1);

		vert[12] = new Vector3(-1, -1, 1);
		vert[13] = new Vector3(-1, -1, -1);
		vert[14] = new Vector3(-1, 1, -1);
		vert[15] = new Vector3(-1, 1, 1);

		vert[16] = new Vector3(-1, 1, -1);
		vert[17] = new Vector3(1, 1, -1);
		vert[18] = new Vector3(1, 1, 1);
		vert[19] = new Vector3(-1, 1, 1);

		vert[20] = new Vector3(-1, -1, 1);
		vert[21] = new Vector3(1, -1, 1);
		vert[22] = new Vector3(1, -1, -1);
		vert[23] = new Vector3(-1, -1, -1);

		int[] tris = { 0, 2, 1, 0, 3, 2, 4, 6, 5, 4, 7, 6, 8, 10, 9, 8, 11, 10,
						 12, 14, 13, 12, 15, 14, 16, 18, 17, 16, 19, 18,
						 20, 22, 21, 20, 23, 22
					   };

		Mesh mesh = new Mesh();
		mesh.vertices = vert;
		mesh.triangles = tris;

		mesh.RecalculateNormals();


		MeshFilter mf = gameObject.AddComponent<MeshFilter>();
		mf.mesh = mesh;

		gameObject.AddComponent<MeshRenderer>();
		Material diffuse = Resources.Load<Material>("Diffuse");
		GetComponent<MeshRenderer>().material = diffuse;
	}
}
