﻿using UnityEngine;
using System.Collections;

public class ParentRevolving : MonoBehaviour 
{
	public float Angle { get; set; }
	public float W { get; set; }
	public float Radius { get; set; }

	private Vector3 ComputePosition()
	{
		return new Vector3(Radius * Mathf.Cos(Angle), 0, Radius * Mathf.Sin(Angle));
	}

	// Use this for initialization
	void Awake() 
	{
		Radius = 1;
		W = 1;
	}
	
	// Update is called once per frame
	void Update () 
	{
		Angle += W * Time.deltaTime;

		Vector3 parentPosition = Vector3.zero;
		if (gameObject.transform.parent != null)
			parentPosition = gameObject.transform.parent.position;

		gameObject.transform.position = parentPosition + ComputePosition();
	}
}
