﻿using UnityEngine;
using System.Collections;

public class InstantiateHierarchy : MonoBehaviour 
{
	public Material material;

	// Use this for initialization
	void Start () 
	{
		GameObject mainSphere = GameObject.CreatePrimitive(PrimitiveType.Sphere);
		mainSphere.GetComponent<MeshRenderer>().material = material;
		mainSphere.AddComponent<ParentRevolving>();

		GameObject secondarySphere = GameObject.CreatePrimitive(PrimitiveType.Sphere);
		secondarySphere.GetComponent<MeshRenderer>().material = material;
		secondarySphere.transform.parent = mainSphere.transform;
		secondarySphere.AddComponent<ParentRevolving>();
		secondarySphere.GetComponent<ParentRevolving>().Radius = 5;
		secondarySphere.GetComponent<ParentRevolving>().W = 2.5f;
		secondarySphere.transform.localScale = new Vector3(0.5f, 0.5f, 0.5f);

		GameObject tertiarySphere = GameObject.CreatePrimitive(PrimitiveType.Sphere);
		tertiarySphere.GetComponent<MeshRenderer>().material = material;
		tertiarySphere.transform.parent = secondarySphere.transform;
		tertiarySphere.AddComponent<ParentRevolving>();
		tertiarySphere.GetComponent<ParentRevolving>().Radius = 3;
		tertiarySphere.GetComponent<ParentRevolving>().W = 4;
		tertiarySphere.transform.localScale = new Vector3(0.5f, 0.5f, 0.5f);
	}
}
