﻿using UnityEngine;

public class ChangeW : MonoBehaviour
{

	private Vector3? oldScale = null;

	void OnTriggerEnter(Collider other)
	{
		ParentRevolving pr = other.gameObject.GetComponent<ParentRevolving>();
		if (pr != null)
		{
			pr.W = (5 * (Random.value + 0.5f))*(Random.value<0.5f?-1:1);
		}
	}

	void OnTriggerStay(Collider other)
	{
		if (oldScale == null)
			oldScale = other.gameObject.transform.localScale;
		other.gameObject.transform.localScale *= 0.95f;
	}

	void OnTriggerExit(Collider other)
	{
		if (oldScale != null)
		{
			other.gameObject.transform.localScale = oldScale.Value;
			oldScale = null;
		}
	}
}
