package jogl2.examples.tutorial.dodatno;

import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;

public class Tabla implements GLEventListener{
	private FPSAnimator animator;
	private GLWindow prozor; // prozor, drawable objekat
	private static String naslov = "Tabla"; // naslov prozora
	private int sirinaProzora = 600, visinaProzora = 500; // sirina i visina prozora
	private static final int FPS = 60; // ucestanost kojom ce objekat animatora da poziva display() metod (videti nize)
	private static final int BROJ_POLJA = 4;

	public Tabla(){
		// Dohvatanje podrazumevanog OpenGL profila (neki od mogucih profila su GL2, GL3, GL4, GLES1...)
		GLProfile glp = GLProfile.getDefault();

		// Podesavanje OpenGL mogucnosti, koje zavise od profila
		GLCapabilities caps = new GLCapabilities(glp);

		caps.setAlphaBits(8);
		caps.setDepthBits(24);
		caps.setDoubleBuffered(true);

		// Pravljenje OpenGL prozora gde ce da se radi iscrtavanje, drawable objekat
		prozor = GLWindow.create(caps);

		// Pravljenje animatora koji ce da poziva display() funkciju (videti nize), sa zadatim FPS.
		animator = new FPSAnimator(prozor, FPS, true);

		prozor.addWindowListener(new WindowAdapter() {
			@Override
			public void windowDestroyNotify(WindowEvent arg0) {
				// Posebna nit poziva metodu stop()
				// kojom se prekida nit animatora, pre nego sto se program zavrsi
				new Thread() {
					@Override
					public void run() {
						animator.stop(); // prekini rad animatora
						System.exit(0);
					}
				}.start();
			};
		});
		prozor.addGLEventListener(this);
		prozor.setSize(sirinaProzora, visinaProzora);
		prozor.setTitle(naslov);
		prozor.setVisible(true);
		animator.start();
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		GL2 gl = drawable.getGL().getGL2();

		// Pozadinska boja se postavlja na belu
		gl.glClearColor(1, 1, 1, 0);

		// Koristi se model nijansiranog sencenja
		gl.glShadeModel(GL2.GL_SMOOTH);

		gl.glPolygonMode(GL.GL_FRONT, GL2.GL_FILL);

		// Ukljucuje se rezim provere dubine pre crtanja
		gl.glEnable(GL2.GL_DEPTH_TEST);
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
	}

	@Override
	public void display(GLAutoDrawable drawable) {
		GL2 gl = drawable.getGL().getGL2();

		// Obrisi bafer za boje i bafer za dubine
		gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);

		// Postavi matricu transformacije MODELA na jedinicnu
		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();

		gl.glTranslatef( 0, 0, -15 );
		gl.glRotatef(20, 1, 0, 0);
		gl.glRotatef(50, 0, 1, 0);
		crtajTablu(drawable, 1, 0.5f, 0.9f, 0.7f);

		gl.glFlush();
	}

	@Override
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		GL2 gl = drawable.getGL().getGL2();

		// Postavljanje viewport-a
		gl.glViewport(0, 0, width, height);
		sirinaProzora = width;
		visinaProzora = height;

		postaviProjekciju(drawable);
	}

	private void postaviProjekciju(GLAutoDrawable drawable) {
		// Dohvatanje OpenGL konteksta
		GL2 gl = drawable.getGL().getGL2();

		// Biranje matrice PROJEKCIJE kao aktivne matrice za buducu manipulaciju
		gl.glMatrixMode(GL2.GL_PROJECTION);
		
		// Postavljanje na jedinicnu matricu
		gl.glLoadIdentity();

		// Ortografska projekcija, gde je vidljiva zapremina paralelopipeda 
		// koji je odredjen sa: x[-15, 15], y[-15, 1.], z[0, 50]
		gl.glOrtho(-15, 15, -15, 15, 0, 50);

		// Vracanje podrazumevane matrice
		gl.glMatrixMode(GL2.GL_MODELVIEW);
	}

	private void crtajTablu(GLAutoDrawable drawable,
			float belaPolja, float crnaPolja, 
			float beleFigure, float crneFigure){

		GL2 gl = drawable.getGL().getGL2();

		gl.glPushMatrix();
			// centriranje podloge
			gl.glTranslatef(-(5*BROJ_POLJA/2), 0, -(5*BROJ_POLJA/2));
			crtajPodlogu(drawable, belaPolja, crnaPolja);
			// postavljanje figura
			for(int i = 0; i < 2; i++){
				for(int j = 0; j < BROJ_POLJA; j++){
					if((i+j) % 2 == 0){
						gl.glPushMatrix();
							gl.glTranslatef(5 * j + 2.5f, 0, 5 * i + 2.5f);
							crtajZeton(drawable, beleFigure);
						gl.glPopMatrix();
					}
					if( (BROJ_POLJA - 1 - i + j) % 2 == 1){
						gl.glPushMatrix();
							gl.glTranslatef(5 * j + 2.5f, 0, 5 * (BROJ_POLJA - 1 - i) + 2.5f);
							crtajZeton(drawable, crneFigure);
						gl.glPopMatrix();
					}
				}
			}

			gl.glPopMatrix();
	}

	private void crtajPodlogu(GLAutoDrawable drawable, float belaPolja, float crnaPolja){
		GL2 gl = drawable.getGL().getGL2();
		// gornje levo teme podloge je u koordinatnom pocetku
		gl.glPushMatrix();
			for(int i = 0; i < BROJ_POLJA; i++){
				for(int j = 0; j < BROJ_POLJA; j++){
					gl.glPushMatrix();
						gl.glTranslatef(5 * j, 0, 5 * i);
						if((i+j) % 2 == 1) gl.glColor3f(belaPolja, belaPolja, belaPolja);
						else gl.glColor3f(crnaPolja, crnaPolja, crnaPolja);

						gl.glBegin(GL2.GL_QUADS);
							gl.glVertex3f(0, 0, 0); gl.glVertex3f(5, 0, 0);
							gl.glVertex3f(5, 0, 5); gl.glVertex3f(0, 0, 5);
						gl.glEnd();
					gl.glPopMatrix();
				}
			}
			gl.glLineWidth(2);
			gl.glBegin(GL2.GL_LINE_STRIP);
				gl.glColor3f(0, 0, 0);
				gl.glVertex3f(0, 0, 0);
				gl.glVertex3f(5*BROJ_POLJA, 0, 0);
				gl.glVertex3f(5*BROJ_POLJA, 0, 5*BROJ_POLJA);
				gl.glVertex3f(0, 0, 5 * BROJ_POLJA);
				gl.glVertex3f(0, 0, 0);
			gl.glEnd();
		gl.glPopMatrix();
	}
	
	private void crtajZeton(GLAutoDrawable drawable, float intenzitet){
		GL2 gl = drawable.getGL().getGL2();

		gl.glColor3f(intenzitet, intenzitet, intenzitet);
		gl.glBegin(GL2.GL_TRIANGLE_FAN);
			gl.glVertex3f(0, 0.5f, 0);
			for(int ugao = 0; ugao <= 360; ugao+=20){
				gl.glVertex3f((float)(2 * Math.cos(Math.toRadians(ugao))),
						0.5f,
						(float)(2 * Math.sin(Math.toRadians(ugao))));
			}
		gl.glEnd();

		gl.glColor3f(intenzitet * 0.8f, intenzitet * 0.8f, intenzitet * 0.8f);

		gl.glBegin(GL2.GL_QUAD_STRIP);
			for(int ugao = 0; ugao <= 360; ugao += 20){
				gl.glVertex3f((float)(2 * Math.cos(Math.toRadians(ugao))),
						0,
						(float)(2 * Math.sin(Math.toRadians(ugao))));
				gl.glVertex3f((float)(2 * Math.cos(Math.toRadians(ugao))),
						0.5f,
						(float)(2 * Math.sin(Math.toRadians(ugao))));
			}
		gl.glEnd();
	}

	public static void main(String args[]){
		new Tabla();
	}
}

