package jogl2.examples.tutorial.dodatno;

import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;

public class Kocke implements GLEventListener{
	private FPSAnimator animator;
	private GLWindow prozor; // prozor, drawable objekat
	private static String naslov = "Kocke"; // naslov prozora
	private int sirinaProzora = 600, visinaProzora = 500; // sirina i visina prozora
	private static final int FPS = 60; // ucestanost kojom ce objekat animatora da poziva display() metod (videti nize)

	private static final float[] 
			tamnoSiva = new float[]{0.3f, 0.3f, 0.3f},
			siva = new float[]{0.6f, 0.6f, 0.6f},
			svetloSiva = new float[]{0.9f, 0.9f, 0.9f},
			crna = new float[]{0, 0, 0};

	public Kocke(){
		// Dohvatanje podrazumevanog OpenGL profila (neki od mogucih profila su GL2, GL3, GL4, GLES1...)
		GLProfile glp = GLProfile.getDefault();

		// Podesavanje OpenGL mogucnosti, koje zavise od profila
		GLCapabilities caps = new GLCapabilities(glp);

		caps.setAlphaBits(8);
		caps.setDepthBits(24);
		caps.setDoubleBuffered(true);

		// Pravljenje OpenGL prozora gde ce da se radi iscrtavanje, drawable objekat
		prozor = GLWindow.create(caps);

		// Pravljenje animatora koji ce da poziva display() funkciju (videti nize), sa zadatim FPS.
		animator = new FPSAnimator(prozor, FPS, true);

		prozor.addWindowListener(new WindowAdapter() {
			@Override
			public void windowDestroyNotify(WindowEvent arg0) {
				// Posebna nit poziva metodu stop()
				// kojom se prekida nit animatora, pre nego sto se program zavrsi
				new Thread() {
					@Override
					public void run() {
						animator.stop(); // prekini rad animatora
						System.exit(0);
					}
				}.start();
			};
		});
		prozor.addGLEventListener(this);
		prozor.setSize(sirinaProzora, visinaProzora);
		prozor.setTitle(naslov);
		prozor.setVisible(true);
		animator.start();
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		GL2 gl = drawable.getGL().getGL2();

		// Pozadinska boja se postavlja na belu
		gl.glClearColor(1, 1, 1, 0);

		// Koristi se model nijansiranog sencenja
		gl.glShadeModel(GL2.GL_SMOOTH);

		// Ukljucuje se rezim provere dubine pre crtanja
		gl.glEnable(GL2.GL_DEPTH_TEST);
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
	}

	@Override
	public void display(GLAutoDrawable drawable) {
		GL2 gl = drawable.getGL().getGL2();

		// Obrisi bafer za boje i bafer za dubine
		gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);

		// Postavi matricu transformacije MODELA na jedinicnu
		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();

		gl.glPushMatrix();
			gl.glTranslatef( 0, 0, -3 );
			gl.glRotatef(45, 0, 1, 0);
			gl.glRotatef(45, 0, 0, 1);

			gl.glPolygonMode(GL2.GL_FRONT, GL2.GL_FILL);
			crtajKocku(drawable, tamnoSiva, siva, svetloSiva);

			gl.glPolygonMode(GL2.GL_FRONT_AND_BACK, GL2.GL_LINE);

			gl.glPushMatrix();
				gl.glTranslatef(1, 0, 0);
				crtajKocku(drawable, crna, crna, crna);
			gl.glPopMatrix();

			gl.glPushMatrix();
				gl.glTranslatef(0, -1, 0);
				crtajKocku(drawable, crna, crna, crna);
			gl.glPopMatrix();
		gl.glPopMatrix();
		
		gl.glFlush();
	}

	@Override
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		GL2 gl = drawable.getGL().getGL2();

		// Postavljanje viewport-a
		gl.glViewport(0, 0, width, height);
		sirinaProzora = width;
		visinaProzora = height;

		postaviProjekciju(drawable);
	}
	
	private void postaviProjekciju(GLAutoDrawable drawable) {
		// Dohvatanje OpenGL konteksta
		GL2 gl = drawable.getGL().getGL2();

		// Biranje matrice PROJEKCIJE kao aktivne matrice za buducu manipulaciju
		gl.glMatrixMode(GL2.GL_PROJECTION);

		// Postavljanje na jedinicnu matricu
		gl.glLoadIdentity();

		// Ortografska projekcija, gde je vidljiva zapremina paralelopipeda
		// koji je odredjen sa: x[-1.5, 1.5], y[-1.5, 1.5], z[0, 6]
		gl.glOrtho(-1.5, 1.5, -1.5, 1.5, 0, 6);

		// Vracanje podrazumevane matrice
		gl.glMatrixMode(GL2.GL_MODELVIEW);
	}

	private void crtajStranu(GLAutoDrawable drawable, float[] boja){
		// Dohvatanje OpenGL konteksta
		GL2 gl = drawable.getGL().getGL2();

		// U smeru suprotnom od smera kazaljke na satu (FRONT side)
		gl.glBegin(GL2.GL_QUADS);
			gl.glColor3fv(boja, 0);
			gl.glVertex2f( -0.5f, -0.5f );
			gl.glVertex2f(  0.5f, -0.5f );
			gl.glVertex2f(  0.5f,  0.5f );
			gl.glVertex2f( -0.5f,  0.5f );
		gl.glEnd();
	}

	private void crtajKocku(GLAutoDrawable drawable, float[] boja1, float[] boja2, float[] boja3){
		// Dohvatanje OpenGL konteksta
		GL2 gl = drawable.getGL().getGL2();

		// prednja i zadnja strana
		crtajStranu(drawable, boja1);
		gl.glPushMatrix();
			gl.glTranslatef(0, 0, -1);
			gl.glRotatef(180, 0, 1, 0);
			crtajStranu(drawable, boja1);
		gl.glPopMatrix();

		// leva i desna strana
		gl.glPushMatrix();
			gl.glTranslatef(0.5f, 0, -0.5f);
			gl.glRotatef(90, 0, 1, 0);
			crtajStranu(drawable, boja2);
			gl.glTranslatef(0, 0, -1);
			gl.glRotatef(180, 0, 1, 0);
			crtajStranu(drawable, boja2);
		gl.glPopMatrix();

		// gornja i donja strana
		gl.glPushMatrix();
			gl.glTranslatef(0, 0.5f, -0.5f);
			gl.glRotatef(-90, 1, 0, 0);
			crtajStranu(drawable, boja3);
			gl.glTranslatef(0, 0, -1);
			gl.glRotatef(180, 0, 1, 0);
			crtajStranu(drawable, boja3);
		gl.glPopMatrix();
	}

	public static void main(String args[]){
		new Kocke();
	}
}
