/* (5) Primer stapanja (BLEND) sa i bez koriscenja tekstura */

package jogl2.examples.tutorial;

import java.awt.Font;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;
// dodatni paketi potrebni za rad sa teksturama
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import de.matthiasmann.twl.utils.PNGDecoder;
import de.matthiasmann.twl.utils.PNGDecoder.Format;
import java.nio.IntBuffer;

public class Stapanje_5 implements GLEventListener, KeyListener{
    private final GLWindow prozor; // prozor, GLAutoDrawable objekat
    private static final String NASLOV = "(5) Stapanje"; // naslov prozora
    private int sirinaProzora = 1000, visinaProzora = 600; // sirina i visina prozora
    float proporcijaProzora; // odnos sirine i visine prozora
    private static final int FPS = 60; // ucestanost kojom ce objekat animatora da poziva display() metod (videti nize)
    private final FPSAnimator animator;
    private TextRenderer txtRenderer;
    private GLU glu;
    private boolean promenaProjekcije = false;
    private int tekuciUgaoVidnogPolja = 60;
    private static final String[] BLEND_FUNC_NAMES = {"ZERO", "ONE", "SRC_COLOR", "ONE_MINUS_SRC_COLOR", "SRC_ALPHA", "ONE_MINUS_SRC_ALPHA", "DST_ALPHA", "ONE_MINUS_DST_ALPHA" };
    private static final int BLEND_FUNC[] = { GL.GL_ZERO, GL.GL_ONE, GL.GL_SRC_COLOR, GL.GL_ONE_MINUS_SRC_COLOR, GL.GL_SRC_ALPHA, GL.GL_ONE_MINUS_SRC_ALPHA, GL.GL_DST_ALPHA, GL.GL_ONE_MINUS_DST_ALPHA };
    private static final String[] BLEND_STATE = {"OFF", "ON"};
    private int mod = 1;
    private int blendState = 1;
    private final int textureID[] = new int[1];
    private int srcFunc = GL.GL_ZERO, dstFunc = GL.GL_ZERO; 
	
    public Stapanje_5(){
        // Dohvatanje podrazumevanog OpenGL profila (neki od mogucih profila su GL2, GL3, GL4, GLES1...)
        GLProfile glp = GLProfile.getDefault();
        // Podesavanje OpenGL mogucnosti, koje zavise od profila
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        //caps.setBackgroundOpaque(true);
        // Pravljenje OpenGL prozora gde ce da se radi iscrtavanje, drawable objekat
        prozor = GLWindow.create(caps);
        // Pravljenje prozora za prikaz renderovane slike; vezuje se OpenGL kontekst
        animator = new FPSAnimator(prozor, FPS, true);
        prozor.addWindowListener(new WindowAdapter() {
            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                animator.stop();
                System.exit(0);
            };
        });
        prozor.addGLEventListener(this);
        prozor.addKeyListener(this);
        prozor.setSize(sirinaProzora, visinaProzora);
        prozor.setTitle(NASLOV);
        prozor.setVisible(true);
        animator.start();
    }
	
    public void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glLoadIdentity();
        glu.gluPerspective(tekuciUgaoVidnogPolja, proporcijaProzora, 1, 40);
        gl.glMatrixMode(GL2.GL_MODELVIEW);
    }
	
    // Poziva se samo jednom neposredno nakon kreiranja OpenGL konteksta
    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        // Pozadinska boja se postavlja na belu
        gl.glClearColor(1, 1, 1, 1);
        // Koristi se model nijansiranog sencenja
        gl.glShadeModel(GL2.GL_SMOOTH);
        // Poligoni se crtaju popunjeno bilo da se posmatraju s lica ili s nalicja
        gl.glPolygonMode(GL2.GL_FRONT_AND_BACK,  GL2.GL_FILL);
        // Ukljucuje se rezim provere dubine pre crtanja
        gl.glEnable(GL2.GL_DEPTH_TEST);
        // Pravljenje objekta za pisanje teksta
        txtRenderer = new TextRenderer(new Font("SansSerif", Font.BOLD, 30));
        // Pravljenje objekta za preko kojeg ce se pozivati pogodne funkcije za rad sa virtuelnom kamerom i matricom perspektive
        glu = GLU.createGLU(gl);
        // Ucitavanje teksture
        LoadGLTexture(drawable, "src/slike/sah.png", textureID);
        gl.glBindTexture(GL.GL_TEXTURE_2D, textureID[0]);
    }

    // Poziva se pre jednom pre unistavanja OpenGL konteksta
    @Override
    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glDeleteTextures(1, IntBuffer.wrap(textureID));
    }

    /** Called back by the drawable to render OpenGL graphics */
    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        // Obrisi bafer za boje i bafer za dubine
        gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
        // Postavi MV matricu na jedinicnu
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();
        //------------ Iscrtavanje ---------------
        if( mod == 1 || mod == 2 ) {
            // Ne koriste se teksture
            gl.glActiveTexture(GL2.GL_TEXTURE0);
            gl.glDisable(GL.GL_TEXTURE_2D);
            // Nema stapanja, boji se jedno preko drugog
            gl.glDisable(GL.GL_BLEND);
            // Centralni kvadrat
            gl.glTranslatef(0, 0, -6);
            gl.glBegin(GL2.GL_QUADS);
                // SIVI
                gl.glColor4f(0.7f, 0.7f, 0.7f, 0.5f);
                gl.glVertex3f( -2.5f, -2.5f, 0 );
                gl.glVertex3f( 2.5f, -2.5f, 0 );
                gl.glVertex3f( 2.5f, 2.5f, 0 );
                gl.glVertex3f( -2.5f, 2.5f, 0 );
            gl.glEnd();
            // Ukljucuje se stapanje
            gl.glEnable(GL.GL_BLEND);
            gl.glBlendFunc(BLEND_FUNC[srcFunc], BLEND_FUNC[dstFunc] );
            // Crtanje nova 4 kvadrata ispred centralnog
            gl.glTranslatef(0, 0, 0.5f);
            gl.glBegin(GL2.GL_QUADS);
                // CRVENI
                gl.glColor4f( 1, 0, 0, 0 );
                gl.glVertex3f( -3, 0.5f, 0 );
                gl.glColor4f( 1, 0, 0, 0.33f );
                gl.glVertex3f( -0.5f, 0.5f, 0 );
                gl.glColor4f( 1, 0, 0, 0.67f );
                gl.glVertex3f( -0.5f, 3, 0 );
                gl.glColor4f( 1, 0, 0, 1 );
                gl.glVertex3f( -3, 3, 0 );
                // ZELENI
                gl.glColor4f( 0, 1, 0, 0 );
                gl.glVertex3f( 0.5f, 0.5f, 0 );
                gl.glColor4f( 0, 1, 0, 0.33f );
                gl.glVertex3f( 3, 0.5f, 0 );
                gl.glColor4f( 0, 1, 0, 0.67f );
                gl.glVertex3f( 3, 3, 0 );
                gl.glColor4f( 0, 1, 0, 1 );
                gl.glVertex3f( 0.5f, 3, 0 );
                // PLAVI
                gl.glColor4f( 0, 0, 1, 0 );
                gl.glVertex3f( -1.25f, -2.5f, 0 );
                gl.glColor4f( 0, 0, 1, 0.33f );
                gl.glVertex3f( 1.25f, -2.5f, 0 );
                gl.glColor4f( 0, 0, 1, 0.67f );
                gl.glVertex3f( 1.25f, 0, 0 );
                gl.glColor4f( 0, 0, 1, 1 );
                gl.glVertex3f( -1.25f, 0, 0 );
            gl.glEnd();

            if( mod == 2 ) {
                // Crtanje novog centralnog kvadrata ispred svega nacrtanog
                gl.glTranslatef(0, 0, 0.5f);
                gl.glBegin(GL2.GL_QUADS);
                    gl.glColor3f(1.0f, 1.0f, 1.0f);
                    gl.glVertex3f( -1.5f, -1.5f, 0 );
                    gl.glVertex3f( 1.5f, -1.5f, 0 );
                    gl.glColor3f(0.0f, 0.0f, 0.0f);
                    gl.glVertex3f( 1.5f, 1.5f, 0 );
                    gl.glVertex3f( -1.5f, 1.5f, 0 );
                gl.glEnd();
            }
            gl.glDisable(GL.GL_BLEND);
        }
        else if( mod ==  3 || mod == 4 ) {
            gl.glActiveTexture(GL2.GL_TEXTURE0);
            gl.glEnable(GL.GL_TEXTURE_2D);
            switch( mod ) {
                case 3:
                    gl.glDisable(GL.GL_BLEND);
                    break;
                case 4:
                    gl.glBlendFunc(BLEND_FUNC[srcFunc], BLEND_FUNC[dstFunc] );
                    gl.glEnable(GL.GL_BLEND);
                    break;
            }
            // Crtanje kvadrata sa slikom
            gl.glBegin(GL2.GL_QUADS);
                gl.glColor4f(1, 1, 1, 1);
                gl.glTexCoord2f( 0, 0 );
                gl.glVertex3f( -2.5f, -2.5f, -6 );
                gl.glTexCoord2f( 1, 0);
                gl.glVertex3f( 2.5f, -2.5f, -6 );
                gl.glTexCoord2f( 1, 1 );
                gl.glVertex3f( 2.5f, 2.5f, -6 );
                gl.glTexCoord2f( 0, 1 );
                gl.glVertex3f( -2.5f, 2.5f, -6 );
            gl.glEnd();
        }
        if(promenaProjekcije){
            postaviProjekciju(drawable);
            promenaProjekcije = false;
        }
        // Ispis menija
        ispisiMeni(drawable);
        //-----------------------------------
    }

    // Poziva se kada se prozor tek pojavi na ekranu
    // i kada se promeni velicina prozora
    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(x, y, width, height);
        sirinaProzora = width;
        visinaProzora = height;
        proporcijaProzora = 1f * sirinaProzora / visinaProzora;
        postaviProjekciju(drawable);
    }
	
    @Override
    public void keyPressed(KeyEvent e) {
        switch(e.getKeyCode()){
            case KeyEvent.VK_UP:
                break;
            case KeyEvent.VK_DOWN:
                break;
            case KeyEvent.VK_LEFT:
                if(tekuciUgaoVidnogPolja > 1){
                    tekuciUgaoVidnogPolja--;
                    promenaProjekcije = true;
                }
                break;
            case KeyEvent.VK_RIGHT:
                if(tekuciUgaoVidnogPolja < 179){
                    tekuciUgaoVidnogPolja++;
                    promenaProjekcije = true;
                }
                break;
            case KeyEvent.VK_ESCAPE:		
                System.exit(0);
                break;
            case KeyEvent.VK_1: case KeyEvent.VK_2: case KeyEvent.VK_3: case KeyEvent.VK_4:
                mod = e.getKeyCode() - '0';
                if(mod == 3) this.blendState = 0;
                else this.blendState = 1;
                break;
            case KeyEvent.VK_F1:
                srcFunc = ( srcFunc + 1 ) % BLEND_FUNC.length;
                break;
            case KeyEvent.VK_F2:
                dstFunc = (dstFunc + 1) %  BLEND_FUNC.length;
                break;
        }
    }
    
    @Override
    public void keyReleased(KeyEvent e) {
    }
	
    public void pisiTekst(String tekst, int x, int y){
        txtRenderer.beginRendering(sirinaProzora, visinaProzora);
            txtRenderer.setColor(0.1f, 1f, 0, 0.8f);
            txtRenderer.draw(tekst, x, y);
        txtRenderer.endRendering();
    }
	
    public void ispisiMeni(GLAutoDrawable drawable){
        pisiTekst("LEVO-DESNO: PROMENA UGLA VIDNOG POLJA " + tekuciUgaoVidnogPolja, 10, visinaProzora - 40);
        pisiTekst("F1: SRC OPERACIJA " + BLEND_FUNC_NAMES[srcFunc], 10, visinaProzora - 80);
        pisiTekst("F2: DST OPERACIJA " + BLEND_FUNC_NAMES[dstFunc], 10, visinaProzora - 120);
        pisiTekst("Mod iscrtavanja: " + mod, 10, visinaProzora - 160);
        pisiTekst("Stapanje: " + BLEND_STATE[blendState], 10, visinaProzora - 200);
    }
	
    // ---------------- deo za ucitavanje sadrzaja png slike ---------------- //
    private ByteBuffer pixelData;
    private int imageWidth, imageHeight;
    private boolean LoadPNG(String filename){
        boolean status = true;
        InputStream in = null;
        try {
            in = new FileInputStream(filename);
            PNGDecoder decoder = new PNGDecoder(in);
            imageWidth = decoder.getWidth(); imageHeight = decoder.getHeight();
            pixelData = ByteBuffer.allocate(4 * imageWidth * imageHeight);
            decoder.decodeFlipped(pixelData, imageWidth * 4, Format.RGBA);
            pixelData.flip(); 
        } catch (IOException e) {
            status = false;
            e.printStackTrace();
        } finally {
            if(in != null){
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return status;
    }
    /**
     * Modifies picture transparency, so alpha is 0, 0.3, 1 and 0.7 going from lower left corner CCW
     * @param pixelData
     * @return 
     */
    private ByteBuffer makeTransparent(ByteBuffer pixelData){
        //pixelData = ByteBuffer.allocate(4 * imageWidth * imageHeight);
        for(int i = 0; i < imageHeight; i++){
            for(int j = 0; j < imageWidth; j++){
                // promeni alfa vrednost svakog piksela
                pixelData.put(i * 4 * imageWidth +  4 * (j + 1) - 1,
                (byte) ((i * 0.3f/(imageHeight-1) + j * 0.7f/(imageWidth-1)) * 255));
            }
        }
        return pixelData;
    }
    private boolean LoadGLTexture(GLAutoDrawable drawable, String textureName, int[] storage){
        boolean status = false;
        GL2 gl = drawable.getGL().getGL2();
        if(LoadPNG(textureName)){
            ByteBuffer transparentImage = makeTransparent(pixelData);
            gl.glGenTextures(1, storage, 0);
            gl.glActiveTexture(GL2.GL_TEXTURE0);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, storage[0]);
            gl.glTexImage2D(GL.GL_TEXTURE_2D, 0, GL.GL_RGBA, imageWidth, imageHeight,
                            0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, transparentImage);
            gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR);
            gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR);
            status = true;
        }
        return status;
    }
	
    public static void main(String[] args){
        new Stapanje_5();
    }
}
