/* (1) DEMONSTRACIJA RAZLIKE ORTOGRAFSKE PROJEKCIJE I PROJEKCIJE SA PERSPEKTIVOM */

package jogl2.examples.tutorial;

import java.awt.Font;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.*;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;

public class Projekcija_1 implements GLEventListener, KeyListener{
    private static final int ORTOGRAFSKA = 0, SA_PERSPEKTIVOM = 1;
    private static final String[] NAZIVI_PROJEKCIJA = {"ORTOGRAFSKA", "SA PERSPEKTIVOM"};
    private int tekucaProjekcija = ORTOGRAFSKA;
    private final GLWindow prozor; // prozor, GLAutoDrawable objekat
    private final String NASLOV = "(1) Projekcija"; // naslov prozora
    private int sirinaProzora = 600, visinaProzora = 800;
    private float proporcijaProzora; // odnos sirine i visine prozora
    private final int SIRINA_ORTOGRAFSKA = 10;
    private static final int FPS = 30; // ucestanost kojom ce animator da poziva display() metod za iscrtavanje scene (videti nize)
    private final FPSAnimator animator;
    private boolean promenaProjekcije = true;
    private TextRenderer txtRenderer;

    public Projekcija_1(){
        // Dohvatanje podrazumevanog OpenGL profila (neki od mogucih profila su GL2, GL3, GL4, GLES1...)
        GLProfile glp = GLProfile.getDefault();
        System.out.println(glp.getGLImplBaseClassName());
        System.out.println(glp.getImplName());
        System.out.println(glp.getName());
        // Postavljanje parametara OpenGL konteksta koji ce biti dodeljen GLWindow instanci 'prozor'
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        // Pravljenje prozora za prikaz renderovane slike; kreirace se OpenGL kontekst
        prozor = GLWindow.create(caps);
        // Pravljenje animatora koji ce da poziva display() funkciju (videti nize) sa zadatom ucestanoscu
        animator = new FPSAnimator(prozor, FPS, true);
        // Dodavanje osluskivaca prozoru
        prozor.addWindowListener(new WindowAdapter() {
            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                animator.stop(); // - zavrsi ciklus (jedina nedemonska nit)
                System.exit(0);
            };
        });
        prozor.addGLEventListener(this);
        prozor.addKeyListener(this);
        prozor.setSize(sirinaProzora, visinaProzora);
        prozor.setTitle(NASLOV);
        prozor.setVisible(true);
        animator.start();
    }
    
    private void postaviProjekciju(GLAutoDrawable drawable) {
        // Dohvatanje OpenGL konteksta - uvek dohvatati kontekst preko prozora
        GL2 gl = drawable.getGL().getGL2();
        // Biranje matrice PROJEKCIJE kao aktivne matrice za buducu manipulaciju
        gl.glMatrixMode(GL2.GL_PROJECTION);
        // Postavljanje na jedinicnu matricu
        gl.glLoadIdentity();
        switch( tekucaProjekcija ) {
            case ORTOGRAFSKA:
                // Ortografska projekcija cije su dimenzije proporcionalne prozoru, pa je slika nedeformisana
                gl.glOrtho(-SIRINA_ORTOGRAFSKA/2, SIRINA_ORTOGRAFSKA/2, -(SIRINA_ORTOGRAFSKA * proporcijaProzora)/2, (SIRINA_ORTOGRAFSKA * proporcijaProzora)/2, 1, 11);
                break;
            case SA_PERSPEKTIVOM:
                // Perspektivna projekcija gde je odnos dimenzija projekcionog platna uvek 1, pa slika moze izgledati deformisano
                gl.glFrustum(-1, 1, -1, 1, 1, 11);
                break;
        }
        // Vracanje MV matrice kao aktivne
        gl.glMatrixMode(GL2.GL_MODELVIEW);
    }

    // Poziva se samo jednom neposredno nakon kreiranja OpenGL konteksta
    @Override
    public void init(GLAutoDrawable drawable) {
        // Tekuci OpenGL kontekst vezan za prozor
        GL2 gl = drawable.getGL().getGL2();
        // Pozadinska boja se postavlja na belu
        gl.glClearColor(1, 1, 1, 0);
        // Koristi se model nijansiranog sencenja (Gouraud shading)
        gl.glShadeModel(GL2.GL_SMOOTH);
        // Poligoni se crtaju popunjeno bilo da se posmatraju s lica ili s nalicja
        gl.glPolygonMode(GL2.GL_FRONT_AND_BACK,  GL2.GL_FILL);
        // Ukljucuje se rezim provere dubine pre crtanja
        gl.glEnable(GL2.GL_DEPTH_TEST);
        // Pravljenje objekta za pisanje teksta
        txtRenderer = new TextRenderer(new Font("SansSerif", Font.BOLD, 20));
        gl.glDrawBuffer(GL2.GL_FRONT_AND_BACK);
    }
    
    // Poziva se pre jednom pre unistavanja OpenGL konteksta
    @Override
    public void dispose(GLAutoDrawable drawable) {
    }

    // Poziva prozor da bi se slika renderovala i prikazala - ciklicni poziv obezbedjen animatorom
    @Override
    public void display(GLAutoDrawable drawable) {
        // Promena projekcija (ukoliko je prethodno bio registrovan zahtev)
        if(promenaProjekcije){
            promenaProjekcije = false;
            postaviProjekciju(drawable);
        }
        // Dohvatanje tekuceg OpenGL konteksta
        GL2 gl = drawable.getGL().getGL2();
        // Brisanje bafera boje i dubine
        gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
        
        // Postavljanje matrice transformacije MODELA na jedinicnu
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();
        //------------ Iscrtavanje ---------------
        // Crtanje scene
        crtajKocku(drawable, -2, 2, -4, 2);
        crtajKocku(drawable, 2, -3, -8, 3);
        crtajKocku(drawable, 2, 2, -10, 1);
        // Ispis menija
        ispisiMeni(drawable);
        //-----------------------------------------
    }

    // Poziva se kada se prozor tek pojavi na ekranu
    // i kada se promeni velicina prozora
    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        // Dohvatanje tekuceg OpenGL konteksta
        GL2 gl = drawable.getGL().getGL2();
        // Postavljanje pozicije i velicine prozora za prikaz renderovane slike
        gl.glViewport(0, 0, width, height);
        sirinaProzora = width;
        visinaProzora = height;
        proporcijaProzora = 1f * visinaProzora/sirinaProzora;
        // Menjanje matrice projekcije u skladu sa novim proporcijama prozora kako slika ne bi bila deformisana
        postaviProjekciju(drawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch(e.getKeyCode()){
            case KeyEvent.VK_LEFT: case KeyEvent.VK_RIGHT:
                tekucaProjekcija = 1 - tekucaProjekcija;
               // postaviProjekciju(prozor);
                promenaProjekcije = true;
                break;
            case KeyEvent.VK_ESCAPE:
                animator.stop(); // prekini program gasenjem jedine nedemonske niti
                break;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    // Crta kocku duzine stranice 'a' sa centrom u (x, y, z)
    private void crtajKocku(GLAutoDrawable drawable, float x, float y, float z, float a){
        
        GL2 gl = drawable.getGL().getGL2();
        
        gl.glBegin(GL2.GL_QUADS);
            gl.glColor3f(1, 0, 0);                      // CRVENA
            gl.glVertex3f(x-a/2, y-a/2, z-a/2);
            gl.glVertex3f(x+a/2, y-a/2, z-a/2);
            gl.glVertex3f(x+a/2, y+a/2, z-a/2);
            gl.glVertex3f(x-a/2, y+a/2, z-a/2);

            gl.glColor3f(0, 1, 0);			// ZELENA
            gl.glVertex3f(x+a/2, y-a/2, z-a/2);
            gl.glVertex3f(x+a/2, y-a/2, z+a/2);
            gl.glVertex3f(x+a/2, y+a/2, z+a/2);
            gl.glVertex3f(x+a/2, y+a/2, z-a/2);

            gl.glColor3f(0, 0, 1);			// PLAVA
            gl.glVertex3f(x-a/2, y+a/2, z-a/2);
            gl.glVertex3f(x+a/2, y+a/2, z-a/2);
            gl.glVertex3f(x+a/2, y+a/2, z+a/2);
            gl.glVertex3f(x-a/2, y+a/2, z+a/2);

            gl.glColor3f(1, 0.5f, 0);                   // NARANDZASTA
            gl.glVertex3f(x-a/2, y-a/2, z+a/2);
            gl.glVertex3f(x-a/2, y-a/2, z-a/2);
            gl.glVertex3f(x-a/2, y+a/2, z-a/2);
            gl.glVertex3f(x-a/2, y+a/2, z+a/2);

            gl.glColor3f(1, 0, 1);			// CIKLAMA
            gl.glVertex3f(x-a/2, y-a/2, z-a/2);
            gl.glVertex3f(x+a/2, y-a/2, z-a/2);
            gl.glVertex3f(x+a/2, y-a/2, z+a/2);
            gl.glVertex3f(x-a/2, y-a/2, z+a/2);

            gl.glColor3f(0.7f, 0, 1);                   // LJUBICASTA
            gl.glVertex3f(x+a/2, y+a/2, z+a/2);
            gl.glVertex3f(x+a/2, y-a/2, z+a/2);
            gl.glVertex3f(x-a/2, y-a/2, z+a/2);
            gl.glVertex3f(x-a/2, y+a/2, z+a/2);
      gl.glEnd();
    }

    public void pisiTekst(String tekst, int x, int y){
        txtRenderer.beginRendering(sirinaProzora, visinaProzora);
            txtRenderer.setColor(1.0f, 0.2f, 0.2f, 0.8f);
            txtRenderer.draw(tekst, x, y);
        txtRenderer.endRendering();
    }

    public void ispisiMeni(GLAutoDrawable drawable){
        // Tekst unutar prozora dimenzija (sirina_prozora x visina_prozora) i koord. pocetak je u donjem levom uglu prozora
        pisiTekst("LEVO-DESNO: PROMENA PROJEKCIJE " + NAZIVI_PROJEKCIJA[tekucaProjekcija], 10, visinaProzora - 20);
    }

    public static void main(String[] args){
        new Projekcija_1();
    }
}
