/* DEMONSTRACIJA PRAVLJENJA OGLEDALA PRIMENOM STENCIL BUFFER-a */

package jogl2.examples.tutorial;

import java.awt.Font;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;

public class Ogledalo_6 implements GLEventListener, KeyListener{
    private final GLWindow prozor; // prozor, GLAutoDrawable objekat
    private static final String NASLOV = "(6) Ogledalo"; // naslov prozora
    private int sirinaProzora = 600, visinaProzora = 500; // sirina i visina prozora
    private float proporcijaProzora; // odnos sirine i visine prozora
    private static final int FPS = 60; // ucestanost kojom ce objekat animatora da poziva display() metod (videti nize)
    private final FPSAnimator animator;
    private TextRenderer txtRenderer;
    private GLU glu;
    private boolean promenaProjekcije = false;
    private int tekuciUgaoVidnogPolja = 90;
    private int tekuciUgaoRotacije = 0;
    private int pozicijaPosmatraca = 0;

    public Ogledalo_6(){
        // Dohvatanje podrazumevanog OpenGL profila (neki od mogucih profila su GL2, GL3, GL4, GLES1...)
        GLProfile glp = GLProfile.getDefault();
        // Podesavanje OpenGL mogucnosti, koje zavise od profila
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setAlphaBits(8);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        caps.setStencilBits(8);
        // Pravljenje prozora za prikaz renderovane slike; vezuje se OpenGL kontekst
        prozor = GLWindow.create(caps);
        // Pravljenje animatora koji ce da poziva display() funkciju (videti nize), sa zadatim FPS.
        animator = new FPSAnimator(prozor, FPS, true);
        prozor.addWindowListener(new WindowAdapter() {
            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                animator.stop();
                System.exit(0);
            };
        });
        prozor.addGLEventListener(this);
        prozor.addKeyListener(this);
        prozor.setSize(sirinaProzora, visinaProzora);
        prozor.setTitle(NASLOV);
        prozor.setVisible(true);
        animator.start();
    }

    public void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glLoadIdentity();
        glu.gluPerspective(tekuciUgaoVidnogPolja, proporcijaProzora, 1, 80);
        gl.glMatrixMode(GL2.GL_MODELVIEW);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        // Pozadinska boja se postavlja na belu
        gl.glClearColor(1, 1, 1, 1);
        // Stencil buffer ce se brisati nulama
        gl.glClearStencil(0);
        // Koristi se model nijansiranog sencenja - Gouraud
        gl.glShadeModel(GL2.GL_SMOOTH);
        // Poligoni se crtaju popunjeno bilo da se posmatraju s lica ili s nalicja
        gl.glPolygonMode(GL2.GL_FRONT_AND_BACK,  GL2.GL_FILL);
        // Ukljucuje se rezim provere dubine pre crtanja
        gl.glEnable(GL2.GL_DEPTH_TEST);
        // Pravljenje objekta za pisanje teksta
        txtRenderer = new TextRenderer(new Font("SansSerif", Font.BOLD, 20));
        // Pravljenje objekta za preko kojeg ce se pozivati pogodne funkcije za rad sa virtuelnom kamerom i matricom perspektive
        glu = GLU.createGLU(gl);
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        // Brisanje bafera boje, dubine i stencil bafera
        gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT | GL.GL_STENCIL_BUFFER_BIT);
        // Podesavanje MVP matrice
        if(promenaProjekcije){
            postaviProjekciju(drawable);
            promenaProjekcije = false;
        }
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();
        postaviPosmatraca();
        //------------ Iscrtavanje ---------------
        crtajScenuBezOgledala(drawable);
        crtajOgledalo(drawable);
        ispisiMeni(drawable);
        //----------------------------------------
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(x, y, width, height);
        sirinaProzora = width;
        visinaProzora = height;
        proporcijaProzora = 1f * sirinaProzora / visinaProzora;
        postaviProjekciju(drawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch(e.getKeyCode()){
        case KeyEvent.VK_UP:
            tekuciUgaoRotacije++;
            break;
        case KeyEvent.VK_DOWN:
            tekuciUgaoRotacije--;
            break;
        case KeyEvent.VK_LEFT:
            if(tekuciUgaoVidnogPolja > 1){
                tekuciUgaoVidnogPolja--;
                promenaProjekcije = true;
            }
            break;
        case KeyEvent.VK_RIGHT:
            if(tekuciUgaoVidnogPolja < 179){
                tekuciUgaoVidnogPolja++;
                promenaProjekcije = true;
            }
            break;
        case KeyEvent.VK_ESCAPE:
            animator.stop();
            System.exit(0);
            break;
        case KeyEvent.VK_0: case KeyEvent.VK_1: case KeyEvent.VK_2: case KeyEvent.VK_3: case KeyEvent.VK_4:
            pozicijaPosmatraca = e.getKeyCode() - '0';
            break;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    // Crta kocku duzine stranice 'a' sa centrom u (x, y, z)
    private void crtajKocku(GLAutoDrawable drawable, float x, float y, float z, float a){
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glPushMatrix();
        gl.glTranslatef(x, y, z);
        gl.glScalef(a, a, a);
        gl.glRotatef(tekuciUgaoRotacije, 1, 1, 1);

        gl.glBegin(GL2.GL_QUADS);
            gl.glColor3f(1, 0, 0);			// CRVENA
            gl.glVertex3f(-0.5f, -0.5f, -0.5f);
            gl.glVertex3f( 0.5f, -0.5f, -0.5f);
            gl.glVertex3f( 0.5f, 0.5f, -0.5f);
            gl.glVertex3f(-0.5f, 0.5f, -0.5f);

            gl.glColor3f(0, 1, 0);			// ZELENA
            gl.glVertex3f(+0.5f, -0.5f, -0.5f);
            gl.glVertex3f(+0.5f, -0.5f, +0.5f);
            gl.glVertex3f(+0.5f, +0.5f, +0.5f);
            gl.glVertex3f(+0.5f, +0.5f, -0.5f);

            gl.glColor3f(0, 0, 1);			// PLAVA
            gl.glVertex3f(-0.5f, +0.5f, -0.5f);
            gl.glVertex3f(+0.5f, +0.5f, -0.5f);
            gl.glVertex3f(+0.5f, +0.5f, +0.5f);
            gl.glVertex3f(-0.5f, +0.5f, +0.5f);

            gl.glColor3f(1, 0.5f, 0);                   // NARANDZASTA
            gl.glVertex3f(-0.5f, -0.5f, +0.5f);
            gl.glVertex3f(-0.5f, -0.5f, -0.5f);
            gl.glVertex3f(-0.5f, +0.5f, -0.5f);
            gl.glVertex3f(-0.5f, +0.5f, +0.5f);


            gl.glColor3f(1, 0, 1);			// CIKLAMA
            gl.glVertex3f(-0.5f, -0.5f, -0.5f);
            gl.glVertex3f(+0.5f, -0.5f, -0.5f);
            gl.glVertex3f(+0.5f, -0.5f, +0.5f);
            gl.glVertex3f(-0.5f, -0.5f, +0.5f);


            gl.glColor3f(0.7f, 0, 1);                   // LJUBICASTA
            gl.glVertex3f(+0.5f, +0.5f, +0.5f);
            gl.glVertex3f(+0.5f, -0.5f, +0.5f);
            gl.glVertex3f(-0.5f, -0.5f, +0.5f);
            gl.glVertex3f(-0.5f, +0.5f, +0.5f);
        gl.glEnd();

        gl.glPopMatrix();
    }

    private void postaviPosmatraca(){
        switch(pozicijaPosmatraca){
        // (0-3): kamera se krece u xz ravni u pozitivnom smeru obrtanja
        case 0:
            glu.gluLookAt( -7.1f, 7.1f, 7.1f,
                            0, 0, 0,
                            0, 1, 0 );
            break;
        case 1:
            glu.gluLookAt( 7.1f, 7.1f, 7.1f,
                            0, 0, 0,
                            0, 1, 0 );
            break;
        case 2:
            glu.gluLookAt( 7.1f, 7.1f, -7.1f,
                            0, 0, 0,
                            0, 1, 0 );
            break;
        case 3:
            glu.gluLookAt( -7.1f, 7.1f, -7.1f,
                            0, 0, 0,
                            0, 1, 0 );
            break;
        case 4:
            glu.gluLookAt( 1, 50, 1,
                            0, 0, 0,
                            0, 1, 0 );
            break;
        }
    }

    private void crtajScenuBezOgledala(GLAutoDrawable drawable){
        crtajPodlogu(drawable, 20);
        crtajKocku(drawable, -2, 2, -4, 2);
        crtajKocku(drawable, 2, -3, -8, 3);
        crtajKocku(drawable, 2, 2, -3, 1);
    }

    private void crtajPodlogu(GLAutoDrawable drawable, float a){
        GL2 gl = drawable.getGL().getGL2();
        gl.glBegin(GL2.GL_QUADS);
            gl.glColor3f(1, 0, 0);
            gl.glVertex3f(-a/2, -5, -a/2);
            gl.glColor3f(0, 1, 0);
            gl.glVertex3f(a/2, -5, -a/2);
            gl.glColor3f(0, 0, 1);
            gl.glVertex3f(a/2, -5, a/2);
            gl.glColor3f(0.4f, 0.4f, 0.4f);
            gl.glVertex3f(-a/2, -5, a/2);
        gl.glEnd();
    }

    private void crtajOgledalo(GLAutoDrawable drawable){
        GL2 gl = drawable.getGL().getGL2();
        //------Pravljenje stencil bafera------
        // Sprecavanje upisa u bafer dubine
        gl.glDepthMask(false);
        // Omogucavanje upisa u sve bite stencil bafera
        gl.glStencilMask(~0);
        // Ukljucivanje stencil testa
        gl.glEnable(GL.GL_STENCIL_TEST);
        // Svaki fragment se poredi ref vrednoscu sa tekucom vrednosti fragmenta u stencil baferu (nakon sto se & sa zadatom maskom)
        // Funkcija poredjenja je takva da novi fragment uvek prolazi stencil test
        gl.glStencilFunc(GL.GL_ALWAYS, 0, ~0);
        // Operacije koje se desavaju sa novom vrednoscu stencil fragmenta u slucaju da
        // - ne prodje stencil test (ostaje stara vrednost)
        // - prodje stencil, ali ne prodje depth test (ostaje stara vrednost)
        // - prodje i stencil i depth test (inkrementira se vrednost)
        // Efekat: U stencil baferu ce biti postavljene jedinice tamo gde treba da bude ogledalo
        gl.glStencilOp(GL.GL_KEEP, GL.GL_KEEP, GL.GL_INCR);
        // Ukljucivanje stapanja boja
        gl.glEnable(GL.GL_BLEND);
        gl.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_ONE_MINUS_SRC_ALPHA);
        // Upis okvira ogledala u stencil bafer i iscrtavanje ogledala bez projektovane slike
        gl.glPushMatrix();
        gl.glRotated(tekuciUgaoRotacije, 0, 1, 0);
        gl.glRotated(10, 0, 0, 1);
        gl.glTranslated(15, 0, 0);
        gl.glRotated(-90, 0, 1, 0);
        gl.glBegin(GL2.GL_QUADS);
            gl.glColor4f(0, 0, 0, 0.1f);
            gl.glVertex3f(-5, -5, 0);
            gl.glVertex3f(5, -5, 0);
            gl.glVertex3f(5, 5, 0);
            gl.glVertex3f(-5, 5, 0);
        gl.glEnd();
        
        // Fragmenti dospevaju u color bafer samo ukoliko im odgovaraju nenulte vrednosti u stencil baferu 
        gl.glStencilFunc(GL.GL_NOTEQUAL, 0, ~0);
        // Stencil bafer se ne menja prilikom iscrtavanja ove sledece slike
        gl.glStencilOp(GL.GL_KEEP, GL.GL_KEEP, GL.GL_KEEP);
        
        gl.glRotated(90, 0, 1, 0);
        gl.glScaled(-1, 1, 1);
        gl.glTranslated(-15, 0, 0);
        gl.glRotated(-10, 0, 0, 1);
        gl.glRotated(-tekuciUgaoRotacije, 0, 1, 0);

        gl.glDepthMask(true);
        // Scena ce da se iscrta simetricno u odnosu ravan ogledala, zahvaljujuci elementarnim transformacijama iznad
        crtajScenuBezOgledala(drawable);

        gl.glDisable(GL.GL_BLEND);
        gl.glDisable(GL.GL_STENCIL_TEST);

        gl.glPopMatrix();
    }

    public void pisiTekst(String tekst, int x, int y){
        txtRenderer.beginRendering(sirinaProzora, visinaProzora);
            txtRenderer.setColor(0.1f, 1f, 0, 0.8f);
            txtRenderer.draw(tekst, x, y);
        txtRenderer.endRendering();
    }

    public void ispisiMeni(GLAutoDrawable drawable){
        GL2 gl = drawable.getGL().getGL2();
        pisiTekst("LEVO-DESNO: PROMENA UGLA VIDNOG POLJA " + tekuciUgaoVidnogPolja, 10, visinaProzora - 20);
        pisiTekst("GORE-DOLE: PROMENA ROTACIJE KOCKI I OGLEDALA " + tekuciUgaoRotacije, 10, visinaProzora - 40);
        pisiTekst("0-4: PROMENA POZICIJE POSMATRACA", 10, visinaProzora - 60);
    }

    public static void main(String[] args){
        new Ogledalo_6();
    }
}
