/* DEMONSTRACIJA JEDNOSTAVNOG TEKSTURIRANJA */

package jogl2.examples.tutorial;

import java.awt.Font;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;
// dodatni paketi potrebni za rad sa teksturama
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import de.matthiasmann.twl.utils.PNGDecoder;
import de.matthiasmann.twl.utils.PNGDecoder.Format;
import java.nio.IntBuffer;

public class JednostavnoTeksturiranje_4 implements GLEventListener, KeyListener{	
    private final GLWindow prozor; // // prozor, GLAutoDrawable objekat
    private final static String NASLOV = "(4) Jednostavno Teksturiranje"; // naslov prozora
    private int sirinaProzora = 800, visinaProzora = 800; // sirina i visina prozora
    private float proporcijaProzora; // odnos sirine i visine prozora
    private static final int FPS = 60; // ucestanost kojom ce objekat animatora da poziva display() metod (videti nize)
    private final FPSAnimator animator;
    private TextRenderer txtRenderer;
    private boolean promenaProjekcije = false;
    private boolean promenaTeksture = false;
    private int tekuciUgaoVidnogPolja = 60;
    private int tekuciUgaoRotacije = 0;
    private float tekucaVisinaKamere = 10;
    private final float inkrementVisine = 2;
    private boolean pauza = true;
    private static final int BROJ_FILTARA = 6;
    private static final String[] NAZIVI_FILTARA = {"min = NEAREST mag = NEAREST", "min = LINEAR mag = LINEAR", 
                                                    "min = NEAREST-NEAREST mag = LINEAR", "min = NEAREST-LINEAR mag = LINEAR", 
                                                    "min = LINEAR-NEAREST mag = LINEAR", "min = LINEAR-LINEAR mag = LINEAR" };
    private int tekucaTekstura = 0;
    private final int textureID[] = new int [BROJ_FILTARA];
    private GLU glu; // sadrzi korisne OpenGL funkcije za apstraktniji rad, recimo sa virtuelnom kamerom ili matricom perspektive

    public JednostavnoTeksturiranje_4(){
          // Dohvatanje podrazumevanog OpenGL profila (neki od mogucih profila su GL2, GL3, GL4, GLES1...)
        GLProfile glp = GLProfile.getGL2GL3();
        // Postavljanje parametara OpenGL konteksta koji biti dodeljen GLWindow instanci 'prozor'
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        // Pravljenje prozora za prikaz renderovane slike; vezuje se OpenGL kontekst
        prozor = GLWindow.create(caps);
        // Pravljenje animatora koji ce da poziva display() funkciju (videti nize) sa zadatom frekvencijom
        animator = new FPSAnimator(prozor, FPS, false);
        // Dodavanje osluskivaca prozoru
        prozor.addWindowListener(new WindowAdapter() {
            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                animator.stop(); // - zavrsi ciklus (jedina nedemonska nit)
                System.exit(0);
            };
        });
        prozor.addGLEventListener(this);
        prozor.addKeyListener(this);
        prozor.setSize(sirinaProzora, visinaProzora);
        prozor.setTitle(NASLOV);
        prozor.setVisible(true);
        animator.start();
    }
	
    public void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glLoadIdentity();
        glu.gluPerspective(tekuciUgaoVidnogPolja, proporcijaProzora, 1, 1200);
        gl.glMatrixMode(GL2.GL_MODELVIEW);
    }
	
   // Poziva se samo jednom neposredno nakon kreiranja OpenGL konteksta
   @Override
   public void init(GLAutoDrawable drawable) {
        // Tekuci OpenGL kontekst vezan za prozor
        GL2 gl = drawable.getGL().getGL2();
        // Pozadinska boja se postavlja na belu
        gl.glClearColor(1, 1, 1, 0);
        // Koristi se model nijansiranog sencenja (Gouraud shading)
        gl.glShadeModel(GL2.GL_SMOOTH);
        // Poligoni se crtaju popunjeno bilo da se posmatraju s lica ili s nalicja
        gl.glPolygonMode(GL2.GL_FRONT_AND_BACK,  GL2.GL_FILL);
        // Ukljucuje se rezim provere dubine pre crtanja
        gl.glEnable(GL2.GL_DEPTH_TEST);
        // Ukljucuje se koriscenje nulte jedinice za teksturiranje - samo kada se ne koriste shader programi!
        gl.glActiveTexture(GL2.GL_TEXTURE0);
        gl.glEnable(GL2.GL_TEXTURE_2D);
        // Pravljenje objekta za pisanje teksta
        txtRenderer = new TextRenderer(new Font("SansSerif", Font.BOLD, 25));
        // Pravljenje objekta za preko kojeg ce se pozivati pogodne funkcije za rad sa virtuelnom kamerom i matricom perspektive
        glu = GLU.createGLU(gl);
        // Ucitavanje teksture
        if(! LoadGLTexture(drawable, "src/slike/sah.png", textureID, 0, GL.GL_NEAREST, GL.GL_NEAREST)) return;
        if(! LoadGLTexture(drawable, "src/slike/sah.png", textureID, 1, GL.GL_LINEAR, GL.GL_LINEAR)) return;
        if(! LoadGLTexture(drawable, "src/slike/sah.png", textureID, 2, GL.GL_NEAREST_MIPMAP_NEAREST, GL.GL_LINEAR)) return;
        if(! LoadGLTexture(drawable, "src/slike/sah.png", textureID, 3, GL.GL_NEAREST_MIPMAP_LINEAR, GL.GL_LINEAR)) return;
        if(! LoadGLTexture(drawable, "src/slike/sah.png", textureID, 4, GL.GL_LINEAR_MIPMAP_NEAREST, GL.GL_LINEAR)) return;
        if(! LoadGLTexture(drawable, "src/slike/sah.png", textureID, 5, GL.GL_LINEAR_MIPMAP_LINEAR, GL.GL_LINEAR)) return;

        gl.glBindTexture(GL.GL_TEXTURE_2D, textureID[0]);
    }

    // Poziva se pre jednom pre unistavanja OpenGL konteksta
    @Override
    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glDeleteTextures(textureID.length, IntBuffer.wrap(textureID));
    }
    
    // Poziva prozor da bi se slika renderovala i prikazala - ciklicni poziv obezbedjen animatorom
    @Override
    public void display(GLAutoDrawable drawable) {
         // Dohvatanje tekuceg OpenGL konteksta
        GL2 gl = drawable.getGL().getGL2();
        // Promena projekcija (ukoliko je prethodno bio registrovan zahtev)
        if(promenaProjekcije){
            postaviProjekciju(drawable);
            promenaProjekcije = false;
        }
        // Promena teksture (ukoliko je prethodno bio registrovan zahtev)
        if(promenaTeksture){
            gl.glActiveTexture(GL2.GL_TEXTURE0);
            gl.glBindTexture(GL.GL_TEXTURE_2D, textureID[tekucaTekstura]);
            promenaTeksture = false;
        }

        // Ukoliko nije zahtevana pauza, nastavlja se rotacija kocke
        if(!pauza){
            tekuciUgaoRotacije += 1;
        }
        // Obrisi bafer za boje i bafer za dubine
        gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
        // Postavi MV matricu na jedinicnu
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();
        // Zadavanje pozicije i orijentacije virtuelne kamere
        glu.gluLookAt(  0, tekucaVisinaKamere, 20,   // pozicija kamere
                        0, -10, 0,  // tacka u koju se gleda 
                        0, 1,  0);  // gore

        //------------ Iscrtavanje ---------------
        // Crtanje kocke koja se rotira i podloge
        crtajKocku(drawable, 0, -10, 0, 5);
        crtajPodlogu(drawable, 1000, 1000);
        // Ispis menija
        ispisiMeni(drawable);
        //-----------------------------------------
    }

    // Poziva se kada se prozor tek pojavi na ekranu
    // i kada se promeni velicina prozora
    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(x, y, width, height);
        sirinaProzora = width;
        visinaProzora = height;
        proporcijaProzora = 1f * visinaProzora/sirinaProzora;
        postaviProjekciju(drawable);
    }
	
    @Override
    public void keyPressed(KeyEvent e) {
        switch(e.getKeyCode()){
            case KeyEvent.VK_UP:
                tekucaVisinaKamere += inkrementVisine;
                break;
            case KeyEvent.VK_DOWN:
                tekucaVisinaKamere -= inkrementVisine;
                break;
            case KeyEvent.VK_LEFT:
                if(tekuciUgaoVidnogPolja > 1){
                    tekuciUgaoVidnogPolja--;
                    promenaProjekcije = true;
                }
                break;
            case KeyEvent.VK_RIGHT:
                if(tekuciUgaoVidnogPolja < 179){
                    tekuciUgaoVidnogPolja++;
                    promenaProjekcije = true;
                }
                break;
            case KeyEvent.VK_ESCAPE:
                animator.stop();
                System.exit(0);
                break;
            case KeyEvent.VK_1: case KeyEvent.VK_2: case KeyEvent.VK_3: case KeyEvent.VK_4:
                break;
            case KeyEvent.VK_F1:
                tekucaTekstura = ( tekucaTekstura - 1 + NAZIVI_FILTARA.length ) % NAZIVI_FILTARA.length;
                promenaTeksture = true;
                break;
            case KeyEvent.VK_F2:
                tekucaTekstura = ( tekucaTekstura + 1 ) % NAZIVI_FILTARA.length;
                promenaTeksture = true;
                break;
            case KeyEvent.VK_SPACE:
                pauza = !pauza;
                break;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
	
    // Crta kocku duzine stranice 'a' sa centrom u (x, y, z)
    private void crtajKocku(GLAutoDrawable drawable, float x, float y, float z, float a){
        GL2 gl = drawable.getGL().getGL2();

        gl.glMatrixMode(GL2.GL_MODELVIEW);
        // Pamti se tekuca MV matrica na steku
        gl.glPushMatrix();
        gl.glTranslatef(x, y, z);
        gl.glScalef(a, a, a);
        gl.glRotatef(tekuciUgaoRotacije, 1, 1, 1);

        gl.glColor3f(1, 1, 1);
        gl.glBegin(GL2.GL_QUADS);
            gl.glTexCoord2f(0, 0);
            gl.glVertex3f(-0.5f, -0.5f, -0.5f);
            gl.glTexCoord2f(1, 0);
            gl.glVertex3f( 0.5f, -0.5f, -0.5f);
            gl.glTexCoord2f(1, 1);
            gl.glVertex3f( 0.5f, 0.5f, -0.5f);
            gl.glTexCoord2f(0, 1);
            gl.glVertex3f(-0.5f, 0.5f, -0.5f);

            gl.glTexCoord2f(0, 0);
            gl.glVertex3f(+0.5f, -0.5f, -0.5f);
            gl.glTexCoord2f(1, 0);
            gl.glVertex3f(+0.5f, -0.5f, +0.5f);
            gl.glTexCoord2f(1, 1);
            gl.glVertex3f(+0.5f, +0.5f, +0.5f);
            gl.glTexCoord2f(0, 1);
            gl.glVertex3f(+0.5f, +0.5f, -0.5f);

            gl.glTexCoord2f(0, 0);
            gl.glVertex3f(-0.5f, +0.5f, -0.5f);
            gl.glTexCoord2f(1, 0);
            gl.glVertex3f(+0.5f, +0.5f, -0.5f);
            gl.glTexCoord2f(1, 1);
            gl.glVertex3f(+0.5f, +0.5f, +0.5f);
            gl.glTexCoord2f(0, 1);
            gl.glVertex3f(-0.5f, +0.5f, +0.5f);

            gl.glTexCoord2f(0, 0);
            gl.glVertex3f(-0.5f, -0.5f, +0.5f);
            gl.glTexCoord2f(1, 0);
            gl.glVertex3f(-0.5f, -0.5f, -0.5f);
            gl.glTexCoord2f(1, 1);
            gl.glVertex3f(-0.5f, +0.5f, -0.5f);
            gl.glTexCoord2f(0, 1);
            gl.glVertex3f(-0.5f, +0.5f, +0.5f);


            gl.glTexCoord2f(0, 0);
            gl.glVertex3f(-0.5f, -0.5f, -0.5f);
            gl.glTexCoord2f(1, 0);
            gl.glVertex3f(+0.5f, -0.5f, -0.5f);
            gl.glTexCoord2f(1, 1);
            gl.glVertex3f(+0.5f, -0.5f, +0.5f);
            gl.glTexCoord2f(0, 1);
            gl.glVertex3f(-0.5f, -0.5f, +0.5f);


            gl.glTexCoord2f(0, 0);
            gl.glVertex3f(-0.5f, -0.5f, +0.5f);
            gl.glTexCoord2f(1, 0);
            gl.glVertex3f( 0.5f, -0.5f, +0.5f);
            gl.glTexCoord2f(1, 1);
            gl.glVertex3f( 0.5f,  0.5f, +0.5f);
            gl.glTexCoord2f(0, 1);
            gl.glVertex3f(-0.5f,  0.5f, +0.5f);
        gl.glEnd();

        // Uzima se prethodno zapamcena matrica sa steka
        gl.glPopMatrix();
    }
    
    // Crta kvadratnu podlogu u nuli sa zadatom pozicijom i dimenzijama sirine i duzine
    private void crtajPodlogu(GLAutoDrawable prozor, float a, float b){
        GL2 gl = prozor.getGL().getGL2();
        float texDim = 100f;
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glPushMatrix();
        gl.glTranslatef(0, -15, 0);
        gl.glRotatef(-90, 1, 0, 0);
        gl.glBegin(GL2.GL_QUADS);
            gl.glTexCoord2f(0, texDim);
            gl.glVertex2f(-a/2, b/2);
            gl.glTexCoord2f(0, 0);
            gl.glVertex2f(-a/2, -b/2);
            gl.glTexCoord2f(texDim, 0);
            gl.glVertex2f(a/2, -b/2);
            gl.glTexCoord2f(texDim, texDim);
            gl.glVertex2f(a/2, b/2);   
        gl.glEnd();
        
        gl.glPopMatrix();
    }
    
    public void pisiTekst(String tekst, int x, int y){
        txtRenderer.beginRendering(sirinaProzora, visinaProzora);
            txtRenderer.setColor(0.1f, 1f, 0, 0.8f);
            txtRenderer.draw(tekst, x, y);
        txtRenderer.endRendering();
    }
	
    public void ispisiMeni(GLAutoDrawable drawable){
        GL2 gl = drawable.getGL().getGL2();
        pisiTekst("LEVO-DESNO: PROMENA UGLA VIDNOG POLJA " + tekuciUgaoVidnogPolja, 10, visinaProzora - 40);
        pisiTekst("RAZMAK: PAUZA ", 10, visinaProzora - 80);
        pisiTekst("F1 - F2: FILTAR " + NAZIVI_FILTARA[tekucaTekstura], 10, visinaProzora - 120);
    }

    // ---------------- deo za ucitavanje sadrzaja  png slike ---------------- //
    private ByteBuffer pixelData;
    private int imageWidth, imageHeight;
    
    private boolean LoadPNG(String filename){
        boolean status = false;
        InputStream in = null;
        try {
            in = new FileInputStream(filename);
            PNGDecoder decoder = new PNGDecoder(in);
            imageWidth = decoder.getWidth(); imageHeight = decoder.getHeight();
            pixelData = ByteBuffer.allocate(4 * imageWidth * imageHeight);
            decoder.decodeFlipped(pixelData, imageWidth * 4, Format.RGBA);
            pixelData.flip();
            status = true;
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if(in != null){
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return status;
    }

    private boolean LoadGLTexture(GLAutoDrawable drawable, String textureName, int[] storage, int ind, int minFilter, int magFilter){
        boolean status = false;
        GL2 gl = drawable.getGL().getGL2();
        if(LoadPNG(textureName)){
            gl.glGenTextures(1, storage, ind);
            gl.glActiveTexture(GL2.GL_TEXTURE0);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, storage[ind]);
            if(minFilter == GL.GL_NEAREST_MIPMAP_NEAREST || minFilter == GL.GL_NEAREST_MIPMAP_LINEAR
            || minFilter == GL.GL_LINEAR_MIPMAP_NEAREST  || minFilter == GL.GL_LINEAR_MIPMAP_LINEAR){
                gl.glTexParameteri(GL.GL_TEXTURE_2D, GL2.GL_GENERATE_MIPMAP, GL.GL_TRUE); // Ako je GL_TRUE, onda ce se sve mipmap slike ponovo izgenerisati ukliko se promeni tekstura nivoa 0
            }
            gl.glTexImage2D(GL.GL_TEXTURE_2D, 0, GL.GL_RGB, imageWidth, imageHeight,
                            0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, pixelData);
            gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, magFilter);
            gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, minFilter);
            status = true;
        }
        return status;
    }

    public static void main(String[] args){
        new JednostavnoTeksturiranje_4();
    }
}
